/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.core;

import cool.scx.core.Scx;
import cool.scx.core.ScxThread;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ScxThreadFactory
implements ThreadFactory {
    private static final AtomicInteger poolNumber = new AtomicInteger(1);
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;
    private final Scx scx;

    ScxThreadFactory(Scx scx) {
        this.scx = scx;
        this.group = Thread.currentThread().getThreadGroup();
        this.namePrefix = "scx-" + poolNumber.getAndIncrement() + "-thread-";
    }

    @Override
    public Thread newThread(Runnable r) {
        ScxThread t = new ScxThread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0, this);
        if (t.isDaemon()) {
            t.setDaemon(false);
        }
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }

    public Scx scx() {
        return this.scx;
    }
}

