/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.core;

import com.fasterxml.jackson.core.type.TypeReference;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import cool.scx.config.ScxConfig;
import cool.scx.config.ScxConfigValueHandler;
import cool.scx.config.ScxEnvironment;
import cool.scx.config.ScxFeature;
import cool.scx.config.ScxFeatureConfig;
import cool.scx.config.handler_impl.AppRootHandler;
import cool.scx.config.handler_impl.ConvertValueHandler;
import cool.scx.config.handler_impl.DefaultValueHandler;
import cool.scx.core.ScxModule;
import cool.scx.core.ScxOptions;
import cool.scx.core.annotation.ScxComponent;
import cool.scx.core.annotation.ScxService;
import cool.scx.core.base.BaseModel;
import cool.scx.core.enumeration.ScxCoreFeature;
import cool.scx.data.jdbc.annotation.Table;
import cool.scx.jdbc.dialect.Dialect;
import cool.scx.jdbc.dialect.DialectSelector;
import cool.scx.jdbc.spy.Spy;
import cool.scx.logging.ScxLogRecorder;
import cool.scx.logging.ScxLoggerConfig;
import cool.scx.logging.ScxLoggerFactory;
import cool.scx.logging.recorder.ConsoleRecorder;
import cool.scx.logging.recorder.FileRecorder;
import cool.scx.mvc.annotation.ScxRoute;
import cool.scx.mvc.annotation.ScxWebSocketRoute;
import cool.scx.util.ConsoleUtils;
import cool.scx.util.ObjectUtils;
import cool.scx.util.StringUtils;
import cool.scx.util.reflect.ClassUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import javax.sql.DataSource;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.scheduling.annotation.ScheduledAnnotationBeanPostProcessor;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;

public final class ScxHelper {
    private static final List<Class<? extends Annotation>> beanFilterAnnotation = List.of(ScxComponent.class, ScxRoute.class, Table.class, ScxService.class, ScxWebSocketRoute.class, Component.class, Controller.class, Service.class, Repository.class);

    public static boolean isBeanClass(Class<?> clazz) {
        for (Class<? extends Annotation> a : beanFilterAnnotation) {
            if (clazz.getAnnotation(a) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isScxBaseModelClass(Class<?> c) {
        return c.isAnnotationPresent(Table.class) && ClassUtils.isInstantiableClass(c) && BaseModel.class.isAssignableFrom(c);
    }

    public static boolean isScxBaseModelServiceClass(Class<?> c) {
        ParameterizedType t;
        Type type;
        return c.isAnnotationPresent(ScxService.class) && ClassUtils.isNormalClass(c) && (type = c.getGenericSuperclass()) instanceof ParameterizedType && (t = (ParameterizedType)type).getActualTypeArguments().length == 1;
    }

    static boolean isUseNewPort(int port) {
        String result;
        do {
            String errMessage = "*******************************************************\n*                                                     *\n*         \u7aef\u53e3\u53f7 [ %s ] \u5df2\u88ab\u5360\u7528, \u662f\u5426\u91c7\u7528\u65b0\u7aef\u53e3\u53f7 ?       *\n*                                                     *\n*                [Y]es    |    [N]o                   *\n*                                                     *\n*******************************************************\n";
            System.err.printf(errMessage + System.lineSeparator(), port);
            result = ConsoleUtils.readLine().trim();
            if (!"Y".equalsIgnoreCase(result)) continue;
            return true;
        } while (!"N".equalsIgnoreCase(result));
        String ignoreMessage = "*******************************************\n*                                         *\n*     N \u7aef\u53e3\u53f7\u88ab\u5360\u7528!!! \u670d\u52a1\u5668\u542f\u52a8\u5931\u8d25 !!!      *\n*                                         *\n*******************************************\n";
        System.err.println(ignoreMessage);
        System.exit(-1);
        return false;
    }

    static DataSource initDataSource(ScxOptions scxOptions, ScxFeatureConfig scxFeatureConfig) {
        String url = scxOptions.dataSourceUrl();
        Dialect dialect = DialectSelector.findDialect((String)url);
        DataSource realDataSource = dialect.createDataSource(url, scxOptions.dataSourceUsername(), scxOptions.dataSourcePassword(), scxOptions.dataSourceParameters());
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setDataSource(realDataSource);
        HikariDataSource hikariDataSource = new HikariDataSource(hikariConfig);
        return (Boolean)scxFeatureConfig.get((ScxFeature)ScxCoreFeature.USE_SPY) != false ? Spy.wrap((DataSource)hikariDataSource) : hikariDataSource;
    }

    static ScxModule[] initScxModuleMetadataList(ScxModule[] scxModules) {
        if (scxModules == null || Arrays.stream(scxModules).noneMatch(Objects::nonNull)) {
            throw new IllegalArgumentException("Modules must not be empty !!!");
        }
        return scxModules;
    }

    static DefaultListableBeanFactory initBeanFactory(ScxModule[] modules, ScheduledExecutorService scheduledExecutorService, ScxFeatureConfig scxFeatureConfig) {
        Class[] beanClass;
        DefaultListableBeanFactory beanFactory = new DefaultListableBeanFactory();
        AutowiredAnnotationBeanPostProcessor beanPostProcessor = new AutowiredAnnotationBeanPostProcessor();
        beanPostProcessor.setBeanFactory((BeanFactory)beanFactory);
        beanFactory.addBeanPostProcessor((BeanPostProcessor)beanPostProcessor);
        if (((Boolean)scxFeatureConfig.get((ScxFeature)ScxCoreFeature.ENABLE_SCHEDULING_WITH_ANNOTATION)).booleanValue()) {
            ScheduledAnnotationBeanPostProcessor scheduledAnnotationBeanPostProcessor = new ScheduledAnnotationBeanPostProcessor();
            scheduledAnnotationBeanPostProcessor.setBeanFactory((BeanFactory)beanFactory);
            scheduledAnnotationBeanPostProcessor.setScheduler((Object)scheduledExecutorService);
            scheduledAnnotationBeanPostProcessor.afterSingletonsInstantiated();
            beanFactory.addBeanPostProcessor((BeanPostProcessor)scheduledAnnotationBeanPostProcessor);
        }
        beanFactory.setAllowCircularReferences(((Boolean)scxFeatureConfig.get((ScxFeature)ScxCoreFeature.ALLOW_CIRCULAR_REFERENCES)).booleanValue());
        for (Class c2 : beanClass = (Class[])Arrays.stream(modules).flatMap(c -> c.classList().stream()).filter(ScxHelper::isBeanClass).toArray(Class[]::new)) {
            AnnotatedGenericBeanDefinition beanDefinition = new AnnotatedGenericBeanDefinition(c2);
            AnnotationConfigUtils.processCommonDefinitionAnnotations((AnnotatedBeanDefinition)beanDefinition);
            beanFactory.registerBeanDefinition(c2.getName(), (BeanDefinition)beanDefinition);
        }
        return beanFactory;
    }

    static void dataSourceExceptionHandler(Exception e) {
        block1: {
            String result;
            do {
                String errMessage = "**************************************************************\n*                                                            *\n*           X \u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25 !!! \u662f\u5426\u5ffd\u7565\u9519\u8bef\u5e76\u7ee7\u7eed\u8fd0\u884c ?            *\n*                                                            *\n*        [Y] \u5ffd\u7565\u9519\u8bef\u5e76\u7ee7\u7eed\u8fd0\u884c    |     [N] \u9000\u51fa\u7a0b\u5e8f              *\n*                                                            *\n**************************************************************\n";
                System.err.println(errMessage);
                result = ConsoleUtils.readLine().trim();
                if (!"Y".equalsIgnoreCase(result)) continue;
                String ignoreMessage = "*******************************************\n*                                         *\n*       N \u6570\u636e\u6e90\u94fe\u63a5\u9519\u8bef,\u7528\u6237\u5df2\u5ffd\u7565 !!!         *\n*                                         *\n*******************************************\n";
                System.err.println(ignoreMessage);
                break block1;
            } while (!"N".equalsIgnoreCase(result));
            e.printStackTrace();
            System.exit(-1);
        }
    }

    static void initScxLoggerFactory(ScxConfig scxConfig, ScxEnvironment scxEnvironment) {
        System.Logger.Level defaultLevel = ScxHelper.toLevel((String)scxConfig.get("scx.logging.default.level", String.class));
        LoggingType defaultType = ScxHelper.toType((String)scxConfig.get("scx.logging.default.type", String.class));
        Path defaultStoredDirectory = (Path)scxConfig.get("scx.logging.default.stored-directory", (ScxConfigValueHandler)AppRootHandler.of((ScxEnvironment)scxEnvironment, (String)"AppRoot:logs"));
        Boolean defaultStackTrace = (Boolean)scxConfig.get("scx.logging.default.stack-trace", (ScxConfigValueHandler)DefaultValueHandler.of((Object)false));
        ScxLoggerConfig defaultConfig = ScxLoggerFactory.rootConfig().clearRecorders();
        defaultConfig.setLevel(defaultLevel);
        if (defaultType == LoggingType.CONSOLE || defaultType == LoggingType.BOTH) {
            defaultConfig.addRecorder(new ScxLogRecorder[]{new ConsoleRecorder()});
        }
        if (defaultType == LoggingType.FILE || defaultType == LoggingType.BOTH) {
            defaultConfig.addRecorder(new ScxLogRecorder[]{new FileRecorder(defaultStoredDirectory)});
        }
        defaultConfig.setStackTrace(defaultStackTrace);
        List loggers = (List)scxConfig.get("scx.logging.loggers", (ScxConfigValueHandler)ConvertValueHandler.of((TypeReference)new TypeReference<List<Map<String, String>>>(){}));
        if (loggers != null) {
            for (Map logger : loggers) {
                String name = (String)logger.get("name");
                if (!StringUtils.notBlank((String)name)) continue;
                System.Logger.Level level = ScxHelper.toLevel((String)logger.get("level"));
                LoggingType type = ScxHelper.toType((String)logger.get("type"));
                Path storedDirectory = StringUtils.notBlank((String)((String)logger.get("stored-directory"))) ? scxEnvironment.getPathByAppRoot((String)logger.get("stored-directory")) : null;
                Boolean stackTrace = (Boolean)ObjectUtils.convertValue(logger.get("stack-trace"), Boolean.class, (ObjectUtils.Option[])new ObjectUtils.Option[0]);
                ScxLoggerConfig config = new ScxLoggerConfig();
                config.setLevel(level);
                if (type == LoggingType.CONSOLE || type == LoggingType.BOTH) {
                    config.addRecorder(new ScxLogRecorder[]{new ConsoleRecorder()});
                }
                if (type == LoggingType.FILE || type == LoggingType.BOTH) {
                    config.addRecorder(new ScxLogRecorder[]{new FileRecorder(storedDirectory != null ? storedDirectory : defaultStoredDirectory)});
                }
                config.setStackTrace(stackTrace);
                ScxLoggerFactory.setConfig((String)name, (ScxLoggerConfig)config);
            }
        }
    }

    private static System.Logger.Level toLevel(String levelName) {
        String s;
        Objects.requireNonNull(levelName, "levelName \u4e0d\u80fd\u4e3a\u7a7a !!!");
        return switch (s = levelName.trim().toUpperCase()) {
            case "OFF", "O" -> System.Logger.Level.OFF;
            case "ERROR", "E" -> System.Logger.Level.ERROR;
            case "WARN", "WARNING", "W" -> System.Logger.Level.WARNING;
            case "INFO", "I" -> System.Logger.Level.INFO;
            case "DEBUG", "D" -> System.Logger.Level.DEBUG;
            case "TRACE", "T" -> System.Logger.Level.TRACE;
            case "ALL", "A" -> System.Logger.Level.ALL;
            default -> null;
        };
    }

    private static LoggingType toType(String loggingTypeName) {
        String s;
        Objects.requireNonNull(loggingTypeName, "loggingTypeName \u4e0d\u80fd\u4e3a\u7a7a !!!");
        return switch (s = loggingTypeName.trim().toUpperCase()) {
            case "CONSOLE", "C" -> LoggingType.CONSOLE;
            case "FILE", "F" -> LoggingType.FILE;
            case "BOTH", "B" -> LoggingType.BOTH;
            default -> null;
        };
    }

    private static enum LoggingType {
        CONSOLE,
        FILE,
        BOTH;

    }
}

