/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.core;

import cool.scx.common.scheduler.ScxScheduler;
import cool.scx.common.util.NetUtils;
import cool.scx.common.util.ScxVirtualThreadFactory;
import cool.scx.common.util.StopWatch;
import cool.scx.common.util.ansi.Ansi;
import cool.scx.common.util.ansi.AnsiElement;
import cool.scx.config.ScxConfig;
import cool.scx.config.ScxEnvironment;
import cool.scx.config.ScxFeature;
import cool.scx.config.ScxFeatureConfig;
import cool.scx.core.ScxBuilder;
import cool.scx.core.ScxContext;
import cool.scx.core.ScxHelper;
import cool.scx.core.ScxHttpRouter;
import cool.scx.core.ScxModule;
import cool.scx.core.ScxOptions;
import cool.scx.core.ScxVersion;
import cool.scx.core.enumeration.ScxCoreFeature;
import cool.scx.core.eventbus.ZeroCopyMessageCodec;
import cool.scx.data.jdbc.AnnotationConfigTable;
import cool.scx.jdbc.JDBCContext;
import cool.scx.jdbc.mapping.Table;
import cool.scx.jdbc.meta_data.SchemaHelper;
import cool.scx.jdbc.sql.SQLRunner;
import cool.scx.mvc.ScxMvc;
import cool.scx.mvc.ScxMvcOptions;
import cool.scx.mvc.ScxRouteRegistrar;
import cool.scx.mvc.ScxWebSocketRouteRegistrar;
import cool.scx.mvc.websocket.WebSocketRouter;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.ext.web.Router;
import java.net.BindException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.sql.DataSource;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public final class Scx {
    private static final System.Logger logger = System.getLogger(Scx.class.getName());
    private final ScxEnvironment scxEnvironment;
    private final String appKey;
    private final ScxFeatureConfig scxFeatureConfig;
    private final ScxConfig scxConfig;
    private final ScxModule[] scxModules;
    private final ScxOptions scxOptions;
    private final ScxScheduler scxScheduler;
    private final Vertx vertx;
    private final DefaultListableBeanFactory beanFactory;
    private final ScxMvc scxMvc;
    private final HttpServerOptions defaultHttpServerOptions;
    private JDBCContext jdbcContext = null;
    private ScxHttpRouter scxHttpRouter = null;
    private WebSocketRouter webSocketRouter = null;
    private HttpServer vertxHttpServer = null;

    Scx(ScxEnvironment scxEnvironment, String appKey, ScxFeatureConfig scxFeatureConfig, ScxConfig scxConfig, ScxModule[] scxModules, VertxOptions vertxOptions, HttpServerOptions defaultHttpServerOptions) {
        ScxContext.scx(this);
        this.scxEnvironment = scxEnvironment;
        this.appKey = appKey;
        this.scxFeatureConfig = scxFeatureConfig;
        this.scxConfig = scxConfig;
        this.scxModules = ScxHelper.initScxModuleMetadataList(scxModules);
        this.scxOptions = new ScxOptions(this.scxConfig, this.scxEnvironment, this.appKey);
        this.defaultHttpServerOptions = defaultHttpServerOptions;
        ScxHelper.initScxLoggerFactory(this.scxConfig, this.scxEnvironment);
        this.scxScheduler = new ScxScheduler(Executors.newScheduledThreadPool(Integer.MAX_VALUE, (ThreadFactory)new ScxVirtualThreadFactory()));
        this.vertx = Vertx.vertx((VertxOptions)vertxOptions);
        ZeroCopyMessageCodec.registerCodec(this.vertx.eventBus());
        this.beanFactory = ScxHelper.initBeanFactory(this.scxModules, (ScheduledExecutorService)this.scxScheduler, this.scxFeatureConfig);
        this.scxMvc = new ScxMvc(new ScxMvcOptions().templateRoot(this.scxOptions.templateRoot()).useDevelopmentErrorPage(((Boolean)scxFeatureConfig.get((ScxFeature)ScxCoreFeature.USE_DEVELOPMENT_ERROR_PAGE)).booleanValue()));
    }

    public static ScxBuilder builder() {
        return new ScxBuilder();
    }

    private void startAllScxModules() {
        for (ScxModule m : this.scxModules) {
            if (((Boolean)this.scxFeatureConfig.get((ScxFeature)ScxCoreFeature.SHOW_MODULE_LIFE_CYCLE_INFO)).booleanValue()) {
                Ansi.ansi().brightWhite((Object)"[", new AnsiElement[0]).brightGreen((Object)"Starting", new AnsiElement[0]).brightWhite((Object)("] " + m.name()), new AnsiElement[0]).println();
            }
            m.start(this);
            if (!((Boolean)this.scxFeatureConfig.get((ScxFeature)ScxCoreFeature.SHOW_MODULE_LIFE_CYCLE_INFO)).booleanValue()) continue;
            Ansi.ansi().brightWhite((Object)"[", new AnsiElement[0]).brightGreen((Object)"Start OK", new AnsiElement[0]).brightWhite((Object)("] " + m.name()), new AnsiElement[0]).println();
        }
    }

    private void stopAllScxModules() {
        if (((Boolean)this.scxFeatureConfig.get((ScxFeature)ScxCoreFeature.SHOW_MODULE_LIFE_CYCLE_INFO)).booleanValue()) {
            for (ScxModule m : this.scxModules) {
                Ansi.ansi().brightWhite((Object)"[", new AnsiElement[0]).brightRed((Object)"Stopping", new AnsiElement[0]).brightWhite((Object)("] " + m.name()), new AnsiElement[0]).println();
                m.stop(this);
                Ansi.ansi().brightWhite((Object)"[", new AnsiElement[0]).brightRed((Object)"Stop  OK", new AnsiElement[0]).brightWhite((Object)("] " + m.name()), new AnsiElement[0]).println();
            }
        } else {
            for (ScxModule m : this.scxModules) {
                m.stop(this);
            }
        }
    }

    public Scx run() {
        StopWatch.start((String)"ScxRun");
        if (((Boolean)this.scxFeatureConfig.get((ScxFeature)ScxCoreFeature.SHOW_BANNER)).booleanValue()) {
            ScxVersion.printBanner();
        }
        if (((Boolean)this.scxFeatureConfig.get((ScxFeature)ScxCoreFeature.SHOW_OPTIONS_INFO)).booleanValue()) {
            this.scxOptions.printInfo();
        }
        this.scxHttpRouter = new ScxHttpRouter(this);
        this.webSocketRouter = new WebSocketRouter();
        List classList = Arrays.stream(this.scxModules()).flatMap(c -> c.classList().stream()).toList();
        Object[] httpRoutes = ScxRouteRegistrar.filterClass(classList).stream().map(arg_0 -> ((DefaultListableBeanFactory)this.beanFactory).getBean(arg_0)).toArray();
        Object[] webSocketRoutes = ScxWebSocketRouteRegistrar.filterClass(classList).stream().map(arg_0 -> ((DefaultListableBeanFactory)this.beanFactory).getBean(arg_0)).toArray();
        this.scxMvc.bindErrorHandler((Router)this.scxHttpRouter).registerHttpRoutes((Router)this.scxHttpRouter, httpRoutes).registerWebSocketRoutes(this.webSocketRouter, webSocketRoutes);
        this.startAllScxModules();
        if (((Boolean)this.scxFeatureConfig.get((ScxFeature)ScxCoreFeature.SHOW_START_UP_INFO)).booleanValue()) {
            Ansi.ansi().brightYellow((Object)("\u5df2\u52a0\u8f7d " + this.beanFactory.getBeanDefinitionNames().length + " \u4e2a Bean !!!"), new AnsiElement[0]).ln().brightGreen((Object)("\u5df2\u52a0\u8f7d " + this.scxHttpRouter.getRoutes().size() + " \u4e2a Http \u8def\u7531 !!!"), new AnsiElement[0]).ln().brightBlue((Object)("\u5df2\u52a0\u8f7d " + this.webSocketRouter.getRoutes().size() + " \u4e2a WebSocket \u8def\u7531 !!!"), new AnsiElement[0]).println();
        }
        HttpServerOptions httpServerOptions = new HttpServerOptions(this.defaultHttpServerOptions);
        if (this.scxOptions.isHttpsEnabled()) {
            httpServerOptions.setSsl(true).setKeyCertOptions((KeyCertOptions)new JksOptions().setPath(this.scxOptions.sslPath().toString()).setPassword(this.scxOptions.sslPassword()));
        }
        this.vertxHttpServer = this.vertx.createHttpServer(httpServerOptions);
        this.vertxHttpServer.requestHandler((Handler)this.scxHttpRouter).webSocketHandler((Handler)this.webSocketRouter);
        this.addShutdownHook();
        this.startServer(this.scxOptions.port());
        this.beanFactory.preInstantiateSingletons();
        return this;
    }

    private void startServer(int port) {
        Future listenFuture = this.vertxHttpServer.listen(port);
        listenFuture.onSuccess(server -> {
            String[] normalIP;
            String httpOrHttps = this.scxOptions.isHttpsEnabled() ? "https" : "http";
            Ansi o = Ansi.ansi().green((Object)("\u670d\u52a1\u5668\u542f\u52a8\u6210\u529f... \u7528\u65f6 " + StopWatch.stopToMillis((String)"ScxRun") + " ms"), new AnsiElement[0]).ln();
            o.green((Object)("> \u672c\u5730: " + httpOrHttps + "://localhost:" + server.actualPort() + "/"), new AnsiElement[0]).ln();
            for (String ip : normalIP = NetUtils.getLocalIPAddress().getNormalIP()) {
                o.green((Object)("> \u7f51\u7edc: " + httpOrHttps + "://" + ip + ":" + server.actualPort() + "/"), new AnsiElement[0]).ln();
            }
            o.print();
        }).onFailure(cause -> {
            if (cause instanceof BindException) {
                if (ScxHelper.isUseNewPort(port)) {
                    this.startServer(0);
                }
            } else {
                cause.printStackTrace();
            }
        });
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            this.stopAllScxModules();
            Ansi.ansi().red((Object)"\u9879\u76ee\u6b63\u5728\u505c\u6b62!!!", new AnsiElement[0]).println();
        }));
    }

    public boolean checkDataSource() {
        boolean bl;
        block8: {
            Connection conn = this.dataSource().getConnection();
            try {
                DatabaseMetaData dm = conn.getMetaData();
                logger.log(System.Logger.Level.DEBUG, "\u6570\u636e\u6e90\u8fde\u63a5\u6210\u529f : \u7c7b\u578b [{0}]  \u7248\u672c [{1}]", dm.getDatabaseProductName(), dm.getDatabaseProductVersion());
                bl = true;
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    ScxHelper.dataSourceExceptionHandler(e);
                    return false;
                }
            }
            conn.close();
        }
        return bl;
    }

    public void fixTable() {
        logger.log(System.Logger.Level.DEBUG, "\u4fee\u590d\u6570\u636e\u8868\u7ed3\u6784\u4e2d...");
        int fixSuccess = 0;
        int fixFail = 0;
        int noNeedToFix = 0;
        for (Class<?> v : this.getAllScxBaseModelClassList()) {
            AnnotationConfigTable tableInfo = new AnnotationConfigTable(v);
            try {
                if (SchemaHelper.checkNeedFixTable((Table)tableInfo, (DataSource)this.dataSource())) {
                    SchemaHelper.fixTable((Table)tableInfo, (JDBCContext)this.jdbcContext);
                    ++fixSuccess;
                    continue;
                }
                ++noNeedToFix;
            }
            catch (Exception e) {
                e.printStackTrace();
                ++fixFail;
            }
        }
        if (fixSuccess != 0) {
            logger.log(System.Logger.Level.DEBUG, "\u4fee\u590d\u6210\u529f {0} \u5f20\u8868...", fixSuccess);
        }
        if (fixFail != 0) {
            logger.log(System.Logger.Level.WARNING, "\u4fee\u590d\u5931\u8d25 {0} \u5f20\u8868...", fixFail);
        }
        if (fixSuccess + fixFail == 0) {
            logger.log(System.Logger.Level.DEBUG, "\u6ca1\u6709\u8868\u9700\u8981\u4fee\u590d...");
        }
    }

    private List<Class<?>> getAllScxBaseModelClassList() {
        return Arrays.stream(this.scxModules).flatMap(c -> c.classList().stream()).filter(ScxHelper::isScxBaseModelClass).toList();
    }

    public boolean checkNeedFixTable() {
        logger.log(System.Logger.Level.DEBUG, "\u68c0\u67e5\u6570\u636e\u8868\u7ed3\u6784\u4e2d...");
        for (Class<?> v : this.getAllScxBaseModelClassList()) {
            AnnotationConfigTable tableInfo = new AnnotationConfigTable(v);
            try {
                if (!SchemaHelper.checkNeedFixTable((Table)tableInfo, (DataSource)this.dataSource())) continue;
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public <T extends ScxModule> T findScxModule(Class<T> clazz) {
        for (ScxModule m : this.scxModules) {
            if (m.getClass() != clazz) continue;
            return (T)m;
        }
        return null;
    }

    public ScxModule[] scxModules() {
        return Arrays.copyOf(this.scxModules, this.scxModules.length);
    }

    public ScxEnvironment scxEnvironment() {
        return this.scxEnvironment;
    }

    public Vertx vertx() {
        return this.vertx;
    }

    public String appKey() {
        return this.appKey;
    }

    public ScxOptions scxOptions() {
        return this.scxOptions;
    }

    public DefaultListableBeanFactory beanFactory() {
        return this.beanFactory;
    }

    public ScxHttpRouter scxHttpRouter() {
        return this.scxHttpRouter;
    }

    public ScxConfig scxConfig() {
        return this.scxConfig;
    }

    public ScxFeatureConfig scxFeatureConfig() {
        return this.scxFeatureConfig;
    }

    public DataSource dataSource() {
        return this.jdbcContext().dataSource();
    }

    public SQLRunner sqlRunner() {
        return this.jdbcContext().sqlRunner();
    }

    public JDBCContext jdbcContext() {
        if (this.jdbcContext == null) {
            DataSource dataSource = ScxHelper.initDataSource(this.scxOptions, this.scxFeatureConfig);
            this.jdbcContext = new JDBCContext(dataSource);
        }
        return this.jdbcContext;
    }

    public HttpServer vertxHttpServer() {
        return this.vertxHttpServer;
    }

    public EventBus eventBus() {
        return this.vertx.eventBus();
    }

    public WebSocketRouter webSocketRouter() {
        return this.webSocketRouter;
    }

    public ScxMvc scxMvc() {
        return this.scxMvc;
    }

    public ScxScheduler scxScheduler() {
        return this.scxScheduler;
    }

    public <T> T getBean(Class<T> requiredType) {
        return (T)this.beanFactory.getBean(requiredType);
    }
}

