/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.core;

import cool.scx.common.util.FileUtils;
import cool.scx.core.Scx;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.util.AsciiString;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.CorsHandler;
import io.vertx.ext.web.handler.impl.BodyHandlerImpl;
import io.vertx.ext.web.handler.impl.CorsHandlerImpl;
import io.vertx.ext.web.impl.RouterImpl;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ScxHttpRouter
extends RouterImpl {
    private static final Set<HttpMethod> DEFAULT_ALLOWED_METHODS = Set.of(HttpMethod.GET, HttpMethod.POST, HttpMethod.OPTIONS, HttpMethod.DELETE, HttpMethod.PATCH, HttpMethod.PUT);
    private static final Set<String> DEFAULT_ALLOWED_HEADERS = ScxHttpRouter.toSet(HttpHeaderNames.ACCEPT, HttpHeaderNames.CONTENT_TYPE);
    private static final Set<String> DEFAULT_EXPOSED_HEADERS = ScxHttpRouter.toSet(HttpHeaderNames.CONTENT_DISPOSITION);
    private static final long DEFAULT_BODY_LIMIT = FileUtils.displaySizeToLong((String)"16384KB");
    private final CorsHandler corsHandler;
    private final BodyHandler bodyHandler;
    private final Route corsHandlerRoute;
    private final Route bodyHandlerRoute;

    public ScxHttpRouter(Scx scx) {
        super(scx.vertx());
        this.corsHandler = ScxHttpRouter.initCorsHandler(scx.scxOptions().allowedOrigin());
        this.bodyHandler = ScxHttpRouter.initBodyHandler(scx.scxEnvironment().getTempPath(new String[]{"file-uploads"}));
        this.corsHandlerRoute = this.route().handler((Handler)this.corsHandler);
        this.bodyHandlerRoute = this.route().handler((Handler)this.bodyHandler);
    }

    private static Set<String> toSet(AsciiString ... values) {
        return Stream.of(values).map(AsciiString::toString).collect(Collectors.toSet());
    }

    static CorsHandler initCorsHandler(String allowedOriginPattern) {
        return new CorsHandlerImpl().addOrigin(allowedOriginPattern).allowedHeaders(DEFAULT_ALLOWED_HEADERS).allowedMethods(DEFAULT_ALLOWED_METHODS).exposedHeaders(DEFAULT_EXPOSED_HEADERS).allowCredentials(true);
    }

    static BodyHandler initBodyHandler(Path uploadDirectory) {
        return new BodyHandlerImpl(uploadDirectory.toString()).setBodyLimit(DEFAULT_BODY_LIMIT).setMergeFormAttributes(false).setDeleteUploadedFilesOnEnd(true);
    }

    public CorsHandler corsHandler() {
        return this.corsHandler;
    }

    public BodyHandler bodyHandler() {
        return this.bodyHandler;
    }

    public Route corsHandlerRoute() {
        return this.corsHandlerRoute;
    }

    public Route bodyHandlerRoute() {
        return this.bodyHandlerRoute;
    }
}

