/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.core.base;

import cool.scx.common.field_filter.FieldFilter;
import cool.scx.core.ScxContext;
import cool.scx.core.ScxHelper;
import cool.scx.core.base.BaseModel;
import cool.scx.data.Query;
import cool.scx.data.QueryBuilder;
import cool.scx.data.jdbc.JDBCDao;
import cool.scx.data.query.WhereOption;
import cool.scx.jdbc.sql.SQL;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;

public class BaseModelService<Entity extends BaseModel> {
    protected final Class<Entity> entityClass;
    private JDBCDao<Entity> dao;

    public BaseModelService() {
        this.entityClass = ScxHelper.findBaseModelServiceEntityClass(this.getClass());
    }

    public BaseModelService(Class<Entity> entityClass) {
        this.entityClass = entityClass;
    }

    private static FieldFilter updateFilterProcessor(FieldFilter updateFilter) {
        return updateFilter.addExcluded(new String[]{"id", "createdDate", "updatedDate"});
    }

    public final Entity add(Entity entity) {
        return this.add(entity, FieldFilter.ofExcluded((String[])new String[0]));
    }

    public Entity add(Entity entity, FieldFilter updateFilter) {
        Long newID = this.dao().add(entity, BaseModelService.updateFilterProcessor(updateFilter));
        return newID != null ? (Entity)this.get(newID) : null;
    }

    public final List<Long> add(Collection<Entity> entityList) {
        return this.add(entityList, FieldFilter.ofExcluded((String[])new String[0]));
    }

    public List<Long> add(Collection<Entity> entityList, FieldFilter updateFilter) {
        return this.dao().add(entityList, BaseModelService.updateFilterProcessor(updateFilter));
    }

    public final List<Entity> find() {
        return this.find(QueryBuilder.query(), FieldFilter.ofExcluded((String[])new String[0]));
    }

    public final List<Entity> find(FieldFilter selectFilter) {
        return this.find(QueryBuilder.query(), selectFilter);
    }

    public final List<Entity> find(Query query) {
        return this.find(query, FieldFilter.ofExcluded((String[])new String[0]));
    }

    public List<Entity> find(Query query, FieldFilter selectFilter) {
        return this.dao().find(query, selectFilter);
    }

    public final void find(Consumer<Entity> consumer) {
        this.find(QueryBuilder.query(), FieldFilter.ofExcluded((String[])new String[0]), consumer);
    }

    public final void find(FieldFilter selectFilter, Consumer<Entity> consumer) {
        this.find(QueryBuilder.query(), selectFilter, consumer);
    }

    public final void find(Query query, Consumer<Entity> consumer) {
        this.find(query, FieldFilter.ofExcluded((String[])new String[0]), consumer);
    }

    public void find(Query query, FieldFilter selectFilter, Consumer<Entity> consumer) {
        this.dao().find(query, selectFilter, consumer);
    }

    public final List<Entity> find(long ... ids) {
        return this.find((Query)(ids.length == 1 ? QueryBuilder.eq((String)"id", (Object)ids[0], (WhereOption[])new WhereOption[0]) : QueryBuilder.in((String)"id", (Object)ids, (WhereOption[])new WhereOption[0])));
    }

    public final Entity get(long id) {
        return this.get(id, FieldFilter.ofExcluded((String[])new String[0]));
    }

    public final Entity get(long id, FieldFilter selectFilter) {
        return this.get((Query)QueryBuilder.eq((String)"id", (Object)id, (WhereOption[])new WhereOption[0]), selectFilter);
    }

    public final Entity get(Query query) {
        return this.get(query, FieldFilter.ofExcluded((String[])new String[0]));
    }

    public Entity get(Query query, FieldFilter selectFilter) {
        return (Entity)((BaseModel)this.dao().get(query, selectFilter));
    }

    public final Entity update(Entity entity) {
        return this.update(entity, FieldFilter.ofExcluded((String[])new String[0]));
    }

    public final Entity update(Entity entity, FieldFilter updateFilter) {
        if (((BaseModel)entity).id == null) {
            throw new RuntimeException("\u6839\u636e id \u66f4\u65b0\u65f6 id \u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.update(entity, (Query)QueryBuilder.eq((String)"id", (Object)((BaseModel)entity).id, (WhereOption[])new WhereOption[0]), updateFilter);
        return this.get(((BaseModel)entity).id);
    }

    public final long update(Entity entity, Query query) {
        return this.update(entity, query, FieldFilter.ofExcluded((String[])new String[0]));
    }

    public long update(Entity entity, Query query, FieldFilter updateFilter) {
        return this.dao().update(entity, query, BaseModelService.updateFilterProcessor(updateFilter));
    }

    public final long delete(long ... ids) {
        if (ids.length == 0) {
            throw new IllegalArgumentException("\u5f85\u5220\u9664\u7684 ids \u6570\u91cf\u81f3\u5c11\u4e3a 1 \u4e2a");
        }
        return this.delete((Query)(ids.length == 1 ? QueryBuilder.eq((String)"id", (Object)ids[0], (WhereOption[])new WhereOption[0]) : QueryBuilder.in((String)"id", (Object)ids, (WhereOption[])new WhereOption[0])));
    }

    public long delete(Query query) {
        return this.dao().delete(query);
    }

    public final long count() {
        return this.count(QueryBuilder.query());
    }

    public final long count(Query query) {
        return this.dao().count(query);
    }

    public final JDBCDao<Entity> dao() {
        if (this.dao == null) {
            this.dao = new JDBCDao(this.entityClass, ScxContext.jdbcContext());
        }
        return this.dao;
    }

    public final Class<Entity> entityClass() {
        return this.entityClass;
    }

    public final SQL buildListSQL(Query query, FieldFilter selectFilter) {
        return this.dao().buildSelectSQL(query, selectFilter);
    }

    public final SQL buildGetSQL(Query query, FieldFilter selectFilter) {
        return this.dao().buildGetSQL(query, selectFilter);
    }

    public final SQL buildListSQLWithAlias(Query query, FieldFilter selectFilter) {
        return this.dao().buildSelectSQLWithAlias(query, selectFilter);
    }

    public final SQL buildGetSQLWithAlias(Query query, FieldFilter selectFilter) {
        return this.dao().buildGetSQLWithAlias(query, selectFilter);
    }
}

