/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.dao.pagination;

public final class Pagination {
    private Integer currentPage;
    private Integer pageSize;

    public Pagination() {
        this.currentPage = null;
        this.pageSize = null;
    }

    public Pagination(Pagination oldPagination) {
        this.currentPage = oldPagination.currentPage;
        this.pageSize = oldPagination.pageSize;
    }

    public Pagination set(Integer currentPage, Integer pageSize) {
        if (currentPage == null || currentPage < 0) {
            throw new IllegalArgumentException("\u5206\u9875\u53c2\u6570\u9519\u8bef : currentPage (\u5206\u9875\u9875\u7801) \u4e0d\u80fd\u4e3a\u7a7a\u6216\u5c0f\u4e8e 0 !!!");
        }
        if (pageSize == null || pageSize < 0) {
            throw new IllegalArgumentException("\u5206\u9875\u53c2\u6570\u9519\u8bef : pageSize (\u6bcf\u9875\u6570\u91cf) \u4e0d\u80fd\u4e3a\u7a7a\u6216\u5c0f\u4e8e 0 !!!");
        }
        this.currentPage = currentPage;
        this.pageSize = pageSize;
        return this;
    }

    public Pagination set(Integer pageSize) {
        return this.set(0, pageSize);
    }

    public Integer offset() {
        return this.pageSize != null && this.currentPage != null ? Integer.valueOf(this.pageSize * this.currentPage) : null;
    }

    public Integer rowCount() {
        return this.pageSize;
    }

    public Pagination clear() {
        this.currentPage = null;
        this.pageSize = null;
        return this;
    }
}

