package cool.scx.dao;

import cool.scx.sql.ColumnInfo;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/**
 * a
 *
 * @param <E> a
 * @author scx567888
 * @version 0.1.3
 */
public abstract class ColumnInfoFilter<E extends ColumnInfoFilter<E>> {

    /**
     * 包含的列
     */
    private final Set<String> fieldNames = new HashSet<>();

    /**
     * 过滤器类型 分三种 禁用 : 0 ,包含模式 : 1 排除模式 : 2
     */
    private final FilterMode filterMode;

    /**
     * a
     *
     * @param filterMode a
     */
    protected ColumnInfoFilter(FilterMode filterMode) {
        this.filterMode = filterMode;
    }

    /**
     * 添加 包含类型的列
     *
     * @param fieldNames 包含的列名 (注意是 java 字段名称 ,不是 数据库 字段名称)
     * @return this 方便链式调用
     */
    private E _addFieldNames(String... fieldNames) {
        this.fieldNames.addAll(Arrays.asList(fieldNames));
        return self();
    }

    /**
     * 根据指定名称 移除 包含类型的列
     *
     * @param fieldNames 包含的列名 (注意是 java 字段名称 ,不是 数据库 字段名称)
     * @return this 方便链式调用
     */
    private E _removeFieldNames(String... fieldNames) {
        for (var fieldName : fieldNames) {
            this.fieldNames.remove(fieldName);
        }
        return self();
    }

    /**
     * 添加 白名单
     *
     * @param fieldNames 包含的列名 (注意是 java 字段名称 ,不是 数据库 字段名称)
     * @return this 方便链式调用
     */
    public final E addIncluded(String... fieldNames) {
        return switch (filterMode) {
            case INCLUDED -> _addFieldNames(fieldNames);
            case EXCLUDED -> _removeFieldNames(fieldNames);
        };
    }

    /**
     * 添加 黑名单
     *
     * @param fieldNames 包含的列名 (注意是 java 字段名称 ,不是 数据库 字段名称)
     * @return this 方便链式调用
     */
    public final E addExcluded(String... fieldNames) {
        return switch (filterMode) {
            case EXCLUDED -> _addFieldNames(fieldNames);
            case INCLUDED -> _removeFieldNames(fieldNames);
        };
    }

    /**
     * 移除白名单
     *
     * @param fieldNames 包含的列名 (注意是 java 字段名称 ,不是 数据库 字段名称)
     * @return this 方便链式调用
     */
    public final E removeIncluded(String... fieldNames) {
        return addExcluded(fieldNames);
    }

    /**
     * 移除黑名单
     *
     * @param fieldNames 包含的列名 (注意是 java 字段名称 ,不是 数据库 字段名称)
     * @return this 方便链式调用
     */
    public final E removeExcluded(String... fieldNames) {
        return addIncluded(fieldNames);
    }

    /**
     * 清除所有 包含类型的列
     *
     * @return this 方便链式调用
     */
    public final E clear() {
        this.fieldNames.clear();
        return self();
    }

    /**
     * 过滤
     *
     * @param scxDaoColumnInfos 带过滤的列表
     * @return 过滤后的列表
     */
    public final ColumnInfo[] filter(ColumnInfo... scxDaoColumnInfos) {
        return this.fieldNames.size() == 0 ? switch (this.filterMode) {
            case INCLUDED -> new ColumnInfo[0];
            case EXCLUDED -> scxDaoColumnInfos;
        } : switch (this.filterMode) {
            case INCLUDED ->
                    Arrays.stream(scxDaoColumnInfos).filter(c -> this.fieldNames.contains(c.javaFieldName())).toArray(ColumnInfo[]::new);
            case EXCLUDED ->
                    Arrays.stream(scxDaoColumnInfos).filter(c -> !this.fieldNames.contains(c.javaFieldName())).toArray(ColumnInfo[]::new);
        };
    }

    /**
     * 获取当前模式
     *
     * @return mode 分三种 禁用 : 0 ,包含模式 : 1 排除模式 : 2
     */
    public FilterMode filterMode() {
        return filterMode;
    }

    /**
     * a
     *
     * @return a
     */
    @SuppressWarnings("unchecked")
    private E self() {
        return (E) this;
    }

    /**
     * 过滤模式
     */
    public enum FilterMode {

        /**
         * 包含模式
         */
        INCLUDED,

        /**
         * 排除模式
         */
        EXCLUDED;

        /**
         * a
         *
         * @param filterModeStr a
         * @return a
         */
        public static FilterMode of(String filterModeStr) {
            return valueOf(filterModeStr.trim().toUpperCase());
        }

    }

}
