package cool.scx.dao;

import cool.scx.sql.TableInfo;

import static cool.scx.util.StringUtils.notBlank;

public final class ColumnNameParser {

    public static String parseColumnName(TableInfo<?> tableInfo, String name, boolean useJsonExtract, boolean useOriginalName) {
        if (useJsonExtract) {
            var c = splitIntoColumnNameAndFieldPath(name);
            if (notBlank(c.columnName()) && notBlank(c.fieldPath())) {
                var jsonQueryColumnName = useOriginalName ? c.columnName() : tableInfo.getColumnInfo(name).columnName();
                return jsonQueryColumnName + " -> " + "'$" + c.fieldPath() + "'";
            } else {
                throw new IllegalArgumentException("使用 USE_JSON_EXTRACT 时, 查询名称不合法 !!! 字段名 : " + name);
            }
        } else {// 这里就是普通的判断一下是否使用 原始名称即可
            return useOriginalName ? name : tableInfo.getColumnInfo(name).columnName();
        }
    }

    public static ColumnNameAndFieldPath splitIntoColumnNameAndFieldPath(String name) {
        var charArray = name.toCharArray();
        var index = charArray.length;
        for (int i = 0; i < charArray.length; i = i + 1) {
            var c = charArray[i];
            if (c == '.' || c == '[') {
                index = i;
                break;
            }
        }
        var columnName = name.substring(0, index);
        var fieldPath = name.substring(index);
        return new ColumnNameAndFieldPath(columnName, fieldPath);
    }

    public record ColumnNameAndFieldPath(String columnName, String fieldPath) {

    }

}
