/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.dao;

import cool.scx.dao.group_by.GroupBy;
import cool.scx.dao.group_by.GroupByOption;
import cool.scx.dao.order_by.OrderBy;
import cool.scx.dao.order_by.OrderByOption;
import cool.scx.dao.order_by.OrderByType;
import cool.scx.dao.pagination.Pagination;
import cool.scx.dao.where.Where;
import cool.scx.dao.where.WhereOption;

public final class Query {
    private final OrderBy orderBy;
    private final GroupBy groupBy;
    private final Where where;
    private final Pagination pagination;

    public Query() {
        this.orderBy = new OrderBy();
        this.groupBy = new GroupBy();
        this.where = new Where();
        this.pagination = new Pagination();
    }

    public Query(Query oldQuery) {
        this.orderBy = new OrderBy(oldQuery.orderBy);
        this.groupBy = new GroupBy(oldQuery.groupBy);
        this.where = new Where(oldQuery.where);
        this.pagination = new Pagination(oldQuery.pagination);
    }

    public OrderBy orderBy() {
        return this.orderBy;
    }

    public GroupBy groupBy() {
        return this.groupBy;
    }

    public Where where() {
        return this.where;
    }

    public Pagination pagination() {
        return this.pagination;
    }

    public Query addGroupBy(String name, GroupByOption ... options) {
        this.groupBy.add(name, options);
        return this;
    }

    public Query removeGroupBy(String name) {
        this.groupBy.remove(name);
        return this;
    }

    public Query clearGroupBy() {
        this.groupBy.clear();
        return this;
    }

    public Query setPagination(Integer currentPage, Integer pageSize) {
        this.pagination.set(currentPage, pageSize);
        return this;
    }

    public Query setPagination(Integer pageSize) {
        this.pagination.set(pageSize);
        return this;
    }

    public Query clearPagination() {
        this.pagination.clear();
        return this;
    }

    public Query addOrderBy(String orderByColumn, OrderByType orderByType, OrderByOption ... options) {
        this.orderBy.add(orderByColumn, orderByType, options);
        return this;
    }

    public Query asc(String name, OrderByOption ... options) {
        this.orderBy.asc(name, options);
        return this;
    }

    public Query desc(String name, OrderByOption ... options) {
        this.orderBy.desc(name, options);
        return this;
    }

    public Query clearOrderBy() {
        this.orderBy.clear();
        return this;
    }

    public Query removeOrderBy(String name) {
        this.orderBy.remove(name);
        return this;
    }

    public Query notIn(String name, Object value, WhereOption ... options) {
        this.where.notIn(name, value, options);
        return this;
    }

    public Query in(String name, Object value, WhereOption ... options) {
        this.where.in(name, value, options);
        return this;
    }

    public Query jsonContains(String name, Object value, WhereOption ... options) {
        this.where.jsonContains(name, value, options);
        return this;
    }

    public Query notLike(String name, Object value, WhereOption ... options) {
        this.where.notLike(name, value, options);
        return this;
    }

    public Query like(String name, Object value, WhereOption ... options) {
        this.where.like(name, value, options);
        return this;
    }

    public Query notLikeRegex(String name, String value, WhereOption ... options) {
        this.where.notLikeRegex(name, value, options);
        return this;
    }

    public Query likeRegex(String name, String value, WhereOption ... options) {
        this.where.likeRegex(name, value, options);
        return this;
    }

    public Query notBetween(String name, Object value1, Object value2, WhereOption ... options) {
        this.where.notBetween(name, value1, value2, options);
        return this;
    }

    public Query between(String name, Object value1, Object value2, WhereOption ... options) {
        this.where.between(name, value1, value2, options);
        return this;
    }

    public Query lessThanOrEqual(String name, Object value, WhereOption ... options) {
        this.where.lessThanOrEqual(name, value, options);
        return this;
    }

    public Query lessThan(String name, Object value, WhereOption ... options) {
        this.where.lessThan(name, value, options);
        return this;
    }

    public Query greaterThanOrEqual(String name, Object value, WhereOption ... options) {
        this.where.greaterThanOrEqual(name, value, options);
        return this;
    }

    public Query greaterThan(String name, Object value, WhereOption ... options) {
        this.where.greaterThan(name, value, options);
        return this;
    }

    public Query notEqual(String name, Object value, WhereOption ... options) {
        this.where.notEqual(name, value, options);
        return this;
    }

    public Query equal(String name, Object value, WhereOption ... options) {
        this.where.equal(name, value, options);
        return this;
    }

    public Query isNotNull(String name, WhereOption ... options) {
        this.where.isNotNull(name, options);
        return this;
    }

    public Query isNull(String name, WhereOption ... options) {
        this.where.isNull(name, options);
        return this;
    }

    public Object[] whereSQL() {
        return this.where.whereSQL();
    }

    public Query whereSQL(Object ... whereSQL) {
        this.where.whereSQL(whereSQL);
        return this;
    }

    public Query removeWhere(String name) {
        this.where.remove(name);
        return this;
    }

    public Query clearWhere() {
        this.where.clear();
        return this;
    }

    public Query clearWhereSQL() {
        this.where.clearWhereSQL();
        return this;
    }

    public Query clearWhereAll() {
        this.where.clearAll();
        return this;
    }
}

