/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.dao.impl;

import cool.scx.dao.annotation.NoColumn;
import cool.scx.dao.annotation.Table;
import cool.scx.dao.impl.AnnotationConfigColumnInfo;
import cool.scx.sql.mapping.ColumnInfo;
import cool.scx.sql.mapping.TableInfo;
import cool.scx.util.CaseUtils;
import cool.scx.util.MultiMap;
import cool.scx.util.StringUtils;
import cool.scx.util.reflect.FieldUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public final class AnnotationConfigTableInfo
implements TableInfo<AnnotationConfigColumnInfo> {
    private final AnnotationConfigColumnInfo[] columnInfos;
    private final String tableName;
    private final Map<String, AnnotationConfigColumnInfo> columnInfoMap;

    public AnnotationConfigTableInfo(Class<?> clazz) {
        this.tableName = AnnotationConfigTableInfo.initTableName(clazz);
        this.columnInfos = AnnotationConfigTableInfo.initAllColumnInfos(clazz);
        this.columnInfoMap = AnnotationConfigTableInfo.initAllColumnInfoMap(this.columnInfos);
    }

    private static AnnotationConfigColumnInfo[] initAllColumnInfos(Class<?> clazz) {
        List<AnnotationConfigColumnInfo> list = Stream.of(FieldUtils.findFields(clazz)).filter(field -> !field.isAnnotationPresent(NoColumn.class)).map(AnnotationConfigColumnInfo::new).toList();
        AnnotationConfigTableInfo.checkDuplicateColumnName(list, clazz);
        return (AnnotationConfigColumnInfo[])list.toArray(AnnotationConfigColumnInfo[]::new);
    }

    private static Map<String, AnnotationConfigColumnInfo> initAllColumnInfoMap(AnnotationConfigColumnInfo[] infos) {
        HashMap<String, AnnotationConfigColumnInfo> map = new HashMap<String, AnnotationConfigColumnInfo>();
        for (AnnotationConfigColumnInfo info : infos) {
            map.put(info.columnName(), info);
        }
        for (AnnotationConfigColumnInfo info : infos) {
            map.put(info.javaFieldName(), info);
        }
        return map;
    }

    private static void checkDuplicateColumnName(List<AnnotationConfigColumnInfo> list, Class<?> clazz) {
        MultiMap multiMap = new MultiMap();
        for (AnnotationConfigColumnInfo info : list) {
            multiMap.put((Object)info.columnName(), (Object)info);
        }
        Map map = multiMap.toMultiValueMap();
        for (Map.Entry entry : map.entrySet()) {
            List v = (List)entry.getValue();
            if (v.size() <= 1) continue;
            throw new IllegalArgumentException("\u91cd\u590d\u7684 columnName !!! Class -> " + clazz.getName() + ", Field -> " + v.stream().map(ColumnInfo::javaFieldName).toList());
        }
    }

    private static String initTableName(Class<?> clazz) {
        Table scxModel = clazz.getAnnotation(Table.class);
        if (scxModel != null && StringUtils.notBlank((String)scxModel.tableName())) {
            return scxModel.tableName();
        }
        if (scxModel != null && StringUtils.notBlank((String)scxModel.tablePrefix())) {
            return scxModel.tablePrefix() + "_" + CaseUtils.toSnake((String)clazz.getSimpleName());
        }
        return "scx_" + CaseUtils.toSnake((String)clazz.getSimpleName());
    }

    public String tableName() {
        return this.tableName;
    }

    public AnnotationConfigColumnInfo[] columnInfos() {
        return this.columnInfos;
    }

    public AnnotationConfigColumnInfo getColumnInfo(String javaFieldName) {
        return this.columnInfoMap.get(javaFieldName);
    }
}

