/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.dao.impl;

import cool.scx.dao.annotation.Column;
import cool.scx.dao.schema.SQLHelper;
import cool.scx.sql.mapping.ColumnInfo;
import cool.scx.util.CaseUtils;
import cool.scx.util.StringUtils;
import java.lang.reflect.Field;

public class AnnotationConfigColumnInfo
implements ColumnInfo {
    private final Field javaField;
    private final String columnName;
    private final String type;
    private final boolean needIndex;
    private final boolean unique;
    private final String onUpdateValue;
    private final String defaultValue;
    private final boolean primaryKey;
    private final boolean autoIncrement;
    private final boolean notNull;

    public AnnotationConfigColumnInfo(Field javaField) {
        this.javaField = javaField;
        Column column = javaField.getAnnotation(Column.class);
        if (column != null) {
            this.type = StringUtils.notBlank((String)column.type()) ? column.type() : SQLHelper.getMySQLTypeCreateName(javaField.getType());
            this.columnName = StringUtils.notBlank((String)column.columnName()) ? column.columnName() : CaseUtils.toSnake((String)javaField.getName());
            this.needIndex = column.needIndex();
            this.unique = column.unique();
            this.onUpdateValue = column.onUpdateValue();
            this.defaultValue = column.defaultValue();
            this.primaryKey = column.primaryKey();
            this.autoIncrement = column.autoIncrement();
            this.notNull = column.notNull();
        } else {
            this.type = SQLHelper.getMySQLTypeCreateName(javaField.getType());
            this.columnName = CaseUtils.toSnake((String)javaField.getName());
            this.needIndex = false;
            this.unique = false;
            this.onUpdateValue = null;
            this.defaultValue = null;
            this.primaryKey = false;
            this.autoIncrement = false;
            this.notNull = false;
        }
        this.javaField.setAccessible(true);
    }

    public Field javaField() {
        return this.javaField;
    }

    public boolean notNull() {
        return this.notNull;
    }

    public boolean primaryKey() {
        return this.primaryKey;
    }

    public boolean autoIncrement() {
        return this.autoIncrement;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public String onUpdateValue() {
        return this.onUpdateValue;
    }

    public String columnName() {
        return this.columnName;
    }

    public String type() {
        return this.type;
    }

    public boolean unique() {
        return this.unique;
    }

    public boolean needIndex() {
        return this.needIndex;
    }
}

