/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.dao.schema;

import com.mysql.cj.MysqlType;
import com.mysql.cj.NativeQueryBindings;
import cool.scx.dao.schema.SchemaVerifyResult;
import cool.scx.sql.SQL;
import cool.scx.sql.SQLRunner;
import cool.scx.sql.mapping.ColumnInfo;
import cool.scx.sql.mapping.TableInfo;
import cool.scx.util.StringUtils;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.sql.DataSource;

public final class SQLHelper {
    private static final Map<Class<?>, MysqlType> DEFAULT_MYSQL_TYPES = SQLHelper.initDefaultMySQLTypes();

    public static String getCreateTableDDL(TableInfo<?> tableInfo) {
        ArrayList<String> createTableDDL = new ArrayList<String>();
        ColumnInfo[] columnInfos = tableInfo.columnInfos();
        String tableName = tableInfo.tableName();
        for (ColumnInfo columnInfo : columnInfos) {
            String normalDDL = SQLHelper.initNormalDDL(columnInfo);
            createTableDDL.add(normalDDL);
        }
        for (ColumnInfo columnInfo : columnInfos) {
            String[] specialDDL = SQLHelper.initSpecialDDL(columnInfo);
            createTableDDL.addAll(List.of(specialDDL));
        }
        return "CREATE TABLE `" + tableName + "` (" + String.join((CharSequence)", ", createTableDDL) + ");";
    }

    public static String getMigrateSQL(TableInfo oldTable, TableInfo newTable) {
        return "";
    }

    public static SchemaVerifyResult verify(TableInfo oldTable, TableInfo newTable) {
        return new SchemaVerifyResult();
    }

    public static SQLType getMySQLType(Class<?> javaType) {
        MysqlType mysqlType = DEFAULT_MYSQL_TYPES.get(javaType);
        if (mysqlType == null) {
            return DEFAULT_MYSQL_TYPES.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isAssignableFrom(javaType)).findFirst().map(Map.Entry::getValue).orElse(null);
        }
        return mysqlType;
    }

    public static String getAlertTableDDL(List<? extends ColumnInfo> nonExistentColumnName, String tableName) {
        ArrayList<CallSite> alertTableDDL = new ArrayList<CallSite>();
        for (ColumnInfo columnInfo : nonExistentColumnName) {
            String normalDDL = SQLHelper.initNormalDDL(columnInfo);
            alertTableDDL.add((CallSite)((Object)("ADD " + normalDDL)));
        }
        for (ColumnInfo columnInfo : nonExistentColumnName) {
            String[] specialDDL;
            for (String s1 : specialDDL = SQLHelper.initSpecialDDL(columnInfo)) {
                alertTableDDL.add((CallSite)((Object)("ADD " + s1)));
            }
        }
        return "ALTER TABLE `" + tableName + "` " + String.join((CharSequence)", ", alertTableDDL) + ";";
    }

    private static String initNormalDDL(ColumnInfo column) {
        ArrayList<Object> tempList = new ArrayList<Object>();
        tempList.add("`" + column.columnName() + "`");
        tempList.add(column.type());
        tempList.add(column.notNull() || column.primaryKey() ? "NOT NULL" : "NULL");
        if (column.autoIncrement()) {
            tempList.add("AUTO_INCREMENT");
        }
        if (StringUtils.notBlank((String)column.defaultValue())) {
            tempList.add("DEFAULT " + column.defaultValue());
        }
        if (StringUtils.notBlank((String)column.onUpdateValue())) {
            tempList.add("ON UPDATE " + column.onUpdateValue());
        }
        return String.join((CharSequence)" ", tempList);
    }

    public static String[] initSpecialDDL(ColumnInfo column) {
        if (column == null) {
            return new String[0];
        }
        String name = column.columnName();
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        if (column.primaryKey()) {
            list.add((CallSite)((Object)("PRIMARY KEY (`" + name + "`)")));
        }
        if (column.unique()) {
            list.add((CallSite)((Object)("UNIQUE KEY `unique_" + name + "`(`" + name + "`)")));
        }
        if (column.needIndex()) {
            list.add((CallSite)((Object)("KEY `index_" + name + "`(`" + name + "`)")));
        }
        return (String[])list.toArray(String[]::new);
    }

    public static void fixTable(TableInfo<?> tableInfo, String databaseName, DataSource dataSource) throws SQLException {
        try (Connection con = dataSource.getConnection();){
            List<String> existingColumn = SQLHelper.getTableAllColumnNames(con, databaseName, tableInfo.tableName());
            if (existingColumn != null) {
                List<ColumnInfo> nonExistentColumnNames = Stream.of(tableInfo.columnInfos()).filter(c -> !existingColumn.contains(c.columnName())).toList();
                if (nonExistentColumnNames.size() > 0) {
                    String alertTableDDL = SQLHelper.getAlertTableDDL(nonExistentColumnNames, tableInfo.tableName());
                    SQLRunner.execute((Connection)con, (SQL)SQL.ofNormal((String)alertTableDDL));
                }
            } else {
                SQLRunner.execute((Connection)con, (SQL)SQL.ofNormal((String)SQLHelper.getCreateTableDDL(tableInfo)));
            }
        }
    }

    public static List<String> getTableAllColumnNames(Connection con, String databaseName, String tableName) throws SQLException {
        DatabaseMetaData dbMetaData = con.getMetaData();
        ResultSet nowTable = dbMetaData.getTables(databaseName, databaseName, tableName, new String[]{"TABLE"});
        if (nowTable.next()) {
            ResultSet nowColumns = dbMetaData.getColumns(databaseName, databaseName, nowTable.getString("TABLE_NAME"), null);
            ArrayList<String> existingColumn = new ArrayList<String>();
            while (nowColumns.next()) {
                existingColumn.add(nowColumns.getString("COLUMN_NAME"));
            }
            return existingColumn;
        }
        return null;
    }

    public static boolean checkNeedFixTable(TableInfo<?> tableInfo, String databaseName, DataSource dataSource) throws SQLException {
        try (Connection con = dataSource.getConnection();){
            List<String> existingColumn = SQLHelper.getTableAllColumnNames(con, databaseName, tableInfo.tableName());
            if (existingColumn != null) {
                List<ColumnInfo> nonExistentColumnNames = Stream.of(tableInfo.columnInfos()).filter(c -> !existingColumn.contains(c.columnName())).toList();
                boolean bl = nonExistentColumnNames.size() != 0;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    private static Map<Class<?>, MysqlType> initDefaultMySQLTypes() {
        HashMap tempMap = new HashMap();
        tempMap.put(Byte.TYPE, MysqlType.TINYINT);
        tempMap.put(Byte[].class, MysqlType.BINARY);
        tempMap.put(Double.TYPE, MysqlType.DOUBLE);
        tempMap.put(Float.TYPE, MysqlType.FLOAT);
        tempMap.put(Integer.TYPE, MysqlType.INT);
        tempMap.put(Long.TYPE, MysqlType.BIGINT);
        tempMap.put(Short.TYPE, MysqlType.SMALLINT);
        tempMap.put(Boolean.TYPE, MysqlType.BOOLEAN);
        try {
            Field f = NativeQueryBindings.class.getDeclaredField("DEFAULT_MYSQL_TYPES");
            f.setAccessible(true);
            Map mysqlDriverDefaultMysqlTypes = (Map)f.get(null);
            tempMap.putAll(mysqlDriverDefaultMysqlTypes);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return tempMap;
    }

    public static String getMySQLTypeCreateName(Class<?> javaType) {
        SQLType mysqlType = SQLHelper.getMySQLType(javaType);
        if (mysqlType == null) {
            mysqlType = javaType.isEnum() ? MysqlType.VARCHAR : MysqlType.JSON;
        }
        return mysqlType == MysqlType.VARCHAR ? mysqlType.getName() + "(128)" : mysqlType.getName();
    }
}

