/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.dao.spy.event;

import com.mysql.cj.PreparedQuery;
import com.mysql.cj.jdbc.ClientPreparedStatement;
import cool.scx.dao.spy.event.SimpleJdbcEventListener;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingEventListener
extends SimpleJdbcEventListener {
    public static final LoggingEventListener INSTANCE = new LoggingEventListener();
    private static final Logger logger = LoggerFactory.getLogger((String)"ScxSpy");

    public static String getFinalSQL(Statement preparedStatement) {
        ClientPreparedStatement clientPreparedStatement;
        try {
            clientPreparedStatement = preparedStatement.unwrap(ClientPreparedStatement.class);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
        PreparedQuery preparedQuery = (PreparedQuery)clientPreparedStatement.getQuery();
        String finalSQL = preparedQuery.asSql();
        int batchedArgsSize = preparedQuery.getBatchedArgs() == null ? 0 : preparedQuery.getBatchedArgs().size();
        return batchedArgsSize > 1 ? finalSQL + "... \u989d\u5916\u7684 " + (batchedArgsSize - 1) + " \u9879" : finalSQL;
    }

    @Override
    public void onBeforeAnyExecute(Statement statement) {
        if (logger.isDebugEnabled()) {
            // empty if block
        }
    }

    @Override
    public void onAfterAnyExecute(Statement statement, long timeElapsedNanos, SQLException e) {
        if (logger.isDebugEnabled()) {
            logger.debug(LoggingEventListener.getFinalSQL(statement));
        }
    }

    @Override
    public void onBeforeAnyAddBatch(Statement Statement2) {
        super.onBeforeAnyAddBatch(Statement2);
    }

    @Override
    public void onAfterAnyAddBatch(Statement Statement2, long timeElapsedNanos, SQLException e) {
        super.onAfterAnyAddBatch(Statement2, timeElapsedNanos, e);
    }
}

