/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.dao.spy.wrapper;

import cool.scx.dao.spy.SpyEventListener;
import cool.scx.dao.spy.event.LoggingEventListener;
import cool.scx.dao.spy.wrapper.ConnectionWrapper;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ConnectionBuilder;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.ShardingKeyBuilder;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class DataSourceWrapper
implements DataSource {
    private final DataSource dataSource;
    private final SpyEventListener eventListener;

    public DataSourceWrapper(DataSource dataSource, SpyEventListener eventListener) {
        this.dataSource = dataSource;
        this.eventListener = eventListener;
    }

    public DataSourceWrapper(DataSource dataSource) {
        this(dataSource, LoggingEventListener.INSTANCE);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return new ConnectionWrapper(this.dataSource.getConnection(), this.eventListener);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return new ConnectionWrapper(this.dataSource.getConnection(username, password), this.eventListener);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.dataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.dataSource.setLogWriter(out);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.dataSource.getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.dataSource.setLoginTimeout(seconds);
    }

    @Override
    public ConnectionBuilder createConnectionBuilder() throws SQLException {
        return this.dataSource.createConnectionBuilder();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.dataSource.getParentLogger();
    }

    @Override
    public ShardingKeyBuilder createShardingKeyBuilder() throws SQLException {
        return this.dataSource.createShardingKeyBuilder();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.dataSource.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.dataSource.isWrapperFor(iface);
    }
}

