/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.dao;

import cool.scx.dao.mapping.ColumnInfo;
import cool.scx.dao.mapping.TableInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public abstract class ColumnInfoFilter<E extends ColumnInfoFilter<E>> {
    private final Set<String> fieldNames = new HashSet<String>();
    private final FilterMode filterMode;

    protected ColumnInfoFilter(FilterMode filterMode) {
        this.filterMode = filterMode;
    }

    private E _addFieldNames(String ... fieldNames) {
        this.fieldNames.addAll(Arrays.asList(fieldNames));
        return this.self();
    }

    private E _removeFieldNames(String ... fieldNames) {
        for (String fieldName : fieldNames) {
            this.fieldNames.remove(fieldName);
        }
        return this.self();
    }

    public final E addIncluded(String ... fieldNames) {
        return switch (this.filterMode) {
            default -> throw new IncompatibleClassChangeError();
            case FilterMode.INCLUDED -> this._addFieldNames(fieldNames);
            case FilterMode.EXCLUDED -> this._removeFieldNames(fieldNames);
        };
    }

    public final E addExcluded(String ... fieldNames) {
        return switch (this.filterMode) {
            default -> throw new IncompatibleClassChangeError();
            case FilterMode.EXCLUDED -> this._addFieldNames(fieldNames);
            case FilterMode.INCLUDED -> this._removeFieldNames(fieldNames);
        };
    }

    public final E removeIncluded(String ... fieldNames) {
        return this.addExcluded(fieldNames);
    }

    public final E removeExcluded(String ... fieldNames) {
        return this.addIncluded(fieldNames);
    }

    public final E clear() {
        this.fieldNames.clear();
        return this.self();
    }

    public final ColumnInfo[] filter(TableInfo<?> tableInfo) {
        ColumnInfo[] columnInfoArray;
        if (this.fieldNames.size() == 0) {
            switch (this.filterMode) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case INCLUDED: {
                    columnInfoArray = new ColumnInfo[]{};
                    break;
                }
                case EXCLUDED: {
                    columnInfoArray = (ColumnInfo[])tableInfo.columns();
                    break;
                }
            }
        } else {
            switch (this.filterMode) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case INCLUDED: {
                    ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
                    for (String fieldName : this.fieldNames) {
                        list.add((ColumnInfo)tableInfo.getColumn(fieldName));
                    }
                    columnInfoArray = (ColumnInfo[])list.toArray(ColumnInfo[]::new);
                    break;
                }
                case EXCLUDED: {
                    ArrayList<ColumnInfo> objects = new ArrayList<ColumnInfo>(Arrays.asList((ColumnInfo[])tableInfo.columns()));
                    for (String fieldName : this.fieldNames) {
                        objects.remove(tableInfo.getColumn(fieldName));
                    }
                    columnInfoArray = (ColumnInfo[])objects.toArray(ColumnInfo[]::new);
                    break;
                }
            }
        }
        return columnInfoArray;
    }

    @Deprecated
    public final ColumnInfo[] filter(ColumnInfo ... scxDaoColumnInfos) {
        ColumnInfo[] columnInfoArray;
        if (this.fieldNames.size() == 0) {
            switch (this.filterMode) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case INCLUDED: {
                    columnInfoArray = new ColumnInfo[]{};
                    break;
                }
                case EXCLUDED: {
                    columnInfoArray = scxDaoColumnInfos;
                    break;
                }
            }
        } else {
            switch (this.filterMode) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case INCLUDED: {
                    columnInfoArray = (ColumnInfo[])Arrays.stream(scxDaoColumnInfos).filter((? super T c) -> this.fieldNames.contains(c.javaFieldName())).toArray(ColumnInfo[]::new);
                    break;
                }
                case EXCLUDED: {
                    columnInfoArray = (ColumnInfo[])Arrays.stream(scxDaoColumnInfos).filter((? super T c) -> !this.fieldNames.contains(c.javaFieldName())).toArray(ColumnInfo[]::new);
                }
            }
        }
        return columnInfoArray;
    }

    public FilterMode filterMode() {
        return this.filterMode;
    }

    private E self() {
        return (E)this;
    }

    public static enum FilterMode {
        INCLUDED,
        EXCLUDED;


        public static FilterMode of(String filterModeStr) {
            return FilterMode.valueOf(filterModeStr.trim().toUpperCase());
        }
    }
}

