/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.dao;

import cool.scx.dao.mapping.ColumnInfo;
import cool.scx.dao.mapping.TableInfo;
import java.sql.Driver;
import java.sql.SQLType;
import java.sql.Statement;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;

public interface Dialect {
    public boolean canHandle(DataSource var1);

    public boolean canHandle(Driver var1);

    public String getFinalSQL(Statement var1);

    default public String getCreateTableDDL(TableInfo<?> tableInfo) {
        List<String> columnDefinitions = this.getColumnDefinitions((ColumnInfo[])tableInfo.columns());
        String str = columnDefinitions.stream().map(c -> "    " + c).collect(Collectors.joining(",\n"));
        return "CREATE TABLE `" + tableInfo.tableName() + "`\n(\n" + str + "\n);";
    }

    default public String getAlertTableDDL(ColumnInfo[] nonExistentColumnNames, String tableName) {
        List<String> columnDefinitions = this.getColumnDefinitions(nonExistentColumnNames);
        String alertTableDDL = columnDefinitions.stream().map(columnDefinition -> "ADD " + columnDefinition).collect(Collectors.joining(", "));
        return "ALTER TABLE `" + tableName + "` " + alertTableDDL + ";";
    }

    public List<String> getColumnDefinitions(ColumnInfo[] var1);

    public String getDataTypeDefinitionByClass(Class<?> var1);

    public SQLType getSQLType(Class<?> var1);

    public String getLimitSQL(String var1, Integer var2, Integer var3);
}

