/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.dao;

import cool.scx.dao.Dialect;
import cool.scx.dao.mapping.ColumnInfo;
import cool.scx.dao.mapping.TableInfo;
import cool.scx.sql.MetaDataHelper;
import cool.scx.sql.SQL;
import cool.scx.sql.SQLRunner;
import cool.scx.sql.mapping.ColumnMapping;
import cool.scx.sql.mapping.TableMapping;
import cool.scx.sql.meta_data.TableMetaData;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.sql.DataSource;

public final class SchemaHelper {
    private static final List<Dialect> DIALECT_LIST = new ArrayList<Dialect>();

    public static Dialect findDialect(Driver realDriver) {
        for (Dialect dialect : DIALECT_LIST) {
            if (!dialect.canHandle(realDriver)) continue;
            return dialect;
        }
        throw new IllegalArgumentException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u65b9\u8a00 !!! " + realDriver.getClass().getName());
    }

    public static Dialect findDialect(DataSource dataSource) {
        for (Dialect dialect : DIALECT_LIST) {
            if (!dialect.canHandle(dataSource)) continue;
            return dialect;
        }
        throw new IllegalArgumentException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u65b9\u8a00 !!! " + dataSource.getClass().getName());
    }

    public static String getMigrateSQL(TableInfo<?> oldTable, TableInfo<?> newTable) {
        return "";
    }

    public static SchemaVerifyResult verify(TableMapping<?, ?> oldTable, TableInfo<?> newTable) {
        ColumnInfo column;
        ArrayList<ColumnInfo> needAdd = new ArrayList<ColumnInfo>();
        ArrayList<ColumnMapping> needRemove = new ArrayList<ColumnMapping>();
        ArrayList<ColumnMapping> needChange = new ArrayList<ColumnMapping>();
        for (ColumnMapping columnMapping : oldTable.columns()) {
            column = (ColumnInfo)newTable.getColumn(columnMapping.columnName());
            if (column != null) continue;
            needRemove.add(columnMapping);
        }
        for (ColumnMapping columnMapping : (ColumnInfo[])newTable.columns()) {
            column = oldTable.getColumn(columnMapping.columnName());
            if (column != null) continue;
            needAdd.add((ColumnInfo)columnMapping);
        }
        return new SchemaVerifyResult(needAdd, needRemove, needChange);
    }

    public static void fixTable(TableInfo<?> tableInfo, String databaseName, DataSource dataSource) throws SQLException {
        Dialect dialect = SchemaHelper.findDialect(dataSource);
        try (Connection con = dataSource.getConnection();){
            Map map = MetaDataHelper.toTablesMap((TableMetaData[])MetaDataHelper.initTables((DatabaseMetaData)con.getMetaData(), (String)databaseName, (String)databaseName, (String)tableInfo.tableName(), null));
            TableMetaData tableMetaData = (TableMetaData)map.get(tableInfo.tableName());
            if (tableMetaData != null) {
                tableMetaData.refreshColumns(con.getMetaData()).refreshPrimaryKeys(con.getMetaData());
                SchemaVerifyResult verify = SchemaHelper.verify(tableMetaData, tableInfo);
                ColumnInfo[] needAdd = verify.getNeedAdd();
                if (needAdd.length > 0) {
                    String alertTableDDL = dialect.getAlertTableDDL(needAdd, tableInfo.tableName());
                    SQLRunner.execute((Connection)con, (SQL)SQL.ofNormal((String)alertTableDDL));
                }
            } else {
                String createTableDDL = dialect.getCreateTableDDL(tableInfo);
                SQLRunner.execute((Connection)con, (SQL)SQL.ofNormal((String)createTableDDL));
            }
        }
    }

    public static boolean checkNeedFixTable(TableInfo<?> tableInfo, String databaseName, DataSource dataSource) throws SQLException {
        block9: {
            try (Connection con = dataSource.getConnection();){
                Map map = MetaDataHelper.toTablesMap((TableMetaData[])MetaDataHelper.initTables((DatabaseMetaData)con.getMetaData(), (String)databaseName, (String)databaseName, (String)tableInfo.tableName(), null));
                TableMetaData tableMetaData = (TableMetaData)map.get(tableInfo.tableName());
                if (tableMetaData != null) {
                    tableMetaData.refreshColumns(con.getMetaData()).refreshPrimaryKeys(con.getMetaData());
                    SchemaVerifyResult verify = SchemaHelper.verify(tableMetaData, tableInfo);
                    ColumnInfo[] needAdd = verify.getNeedAdd();
                    if (needAdd.length > 0) {
                        boolean bl = true;
                        return bl;
                    }
                    break block9;
                }
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    static {
        ServiceLoader<Dialect> loader = ServiceLoader.load(Dialect.class);
        for (Dialect dialect : loader) {
            DIALECT_LIST.add(dialect);
        }
    }

    public static class SchemaVerifyResult {
        private final ColumnInfo[] needAdd;
        private final ArrayList<ColumnMapping> needRemove;
        private final ArrayList<ColumnMapping> needChange;

        public SchemaVerifyResult(ArrayList<ColumnInfo> needAdd, ArrayList<ColumnMapping> needRemove, ArrayList<ColumnMapping> needChange) {
            this.needAdd = (ColumnInfo[])needAdd.toArray(ColumnInfo[]::new);
            this.needRemove = needRemove;
            this.needChange = needChange;
        }

        public ColumnInfo[] getNeedAdd() {
            return this.needAdd;
        }

        public ArrayList<ColumnMapping> getNeedRemove() {
            return this.needRemove;
        }

        public ArrayList<ColumnMapping> getNeedChange() {
            return this.needChange;
        }
    }
}

