/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.dao.dialect;

import com.mysql.cj.MysqlType;
import com.mysql.cj.NativeQueryBindings;
import com.mysql.cj.PreparedQuery;
import com.mysql.cj.jdbc.ClientPreparedStatement;
import com.mysql.cj.jdbc.MysqlDataSource;
import cool.scx.dao.Dialect;
import cool.scx.dao.mapping.ColumnInfo;
import cool.scx.util.StringUtils;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public class MySQLDialect
implements Dialect {
    private static final Map<Class<?>, MysqlType> DEFAULT_MYSQL_TYPES = new HashMap();

    public static String[] initSpecialDDL(ColumnInfo column) {
        if (column == null) {
            return new String[0];
        }
        String name = column.columnName();
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        if (column.primaryKey()) {
            list.add((CallSite)((Object)("PRIMARY KEY (`" + name + "`)")));
        }
        if (column.unique()) {
            list.add((CallSite)((Object)("UNIQUE KEY `unique_" + name + "`(`" + name + "`)")));
        }
        if (column.needIndex()) {
            list.add((CallSite)((Object)("KEY `index_" + name + "`(`" + name + "`)")));
        }
        return (String[])list.toArray(String[]::new);
    }

    @Override
    public boolean canHandle(DataSource dataSource) {
        try {
            return dataSource instanceof MysqlDataSource || dataSource.isWrapperFor(MysqlDataSource.class);
        }
        catch (SQLException e) {
            return false;
        }
    }

    @Override
    public boolean canHandle(Driver driver) {
        return driver instanceof com.mysql.cj.jdbc.Driver;
    }

    @Override
    public String getFinalSQL(Statement preparedStatement) {
        ClientPreparedStatement clientPreparedStatement;
        try {
            clientPreparedStatement = preparedStatement.unwrap(ClientPreparedStatement.class);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
        PreparedQuery preparedQuery = (PreparedQuery)clientPreparedStatement.getQuery();
        String finalSQL = preparedQuery.asSql();
        int batchedArgsSize = preparedQuery.getBatchedArgs() == null ? 0 : preparedQuery.getBatchedArgs().size();
        return batchedArgsSize > 1 ? finalSQL + "... \u989d\u5916\u7684 " + (batchedArgsSize - 1) + " \u9879" : finalSQL;
    }

    private String initNormalDDL(ColumnInfo column) {
        ArrayList<Object> tempList = new ArrayList<Object>();
        tempList.add("`" + column.columnName() + "`");
        tempList.add(this.getDataTypeDefinition(column));
        tempList.add(column.notNull() || column.primaryKey() ? "NOT NULL" : "NULL");
        if (column.autoIncrement()) {
            tempList.add("AUTO_INCREMENT");
        }
        if (StringUtils.notBlank((String)column.defaultValue())) {
            tempList.add("DEFAULT " + column.defaultValue());
        }
        if (StringUtils.notBlank((String)column.onUpdateValue())) {
            tempList.add("ON UPDATE " + column.onUpdateValue());
        }
        return String.join((CharSequence)" ", tempList);
    }

    @Override
    public List<String> getColumnDefinitions(ColumnInfo[] columnInfos) {
        ArrayList<String> createTableDDL = new ArrayList<String>();
        for (ColumnInfo columnInfo : columnInfos) {
            String normalDDL = this.initNormalDDL(columnInfo);
            createTableDDL.add(normalDDL);
        }
        for (ColumnInfo columnInfo : columnInfos) {
            String[] specialDDL = MySQLDialect.initSpecialDDL(columnInfo);
            createTableDDL.addAll(List.of(specialDDL));
        }
        return createTableDDL;
    }

    @Override
    public String getDataTypeDefinitionByClass(Class<?> javaType) {
        SQLType mysqlType = this.getSQLType(javaType);
        if (mysqlType == null) {
            mysqlType = javaType.isEnum() ? MysqlType.VARCHAR : MysqlType.JSON;
        }
        return mysqlType == MysqlType.VARCHAR ? mysqlType.getName() + "(128)" : mysqlType.getName();
    }

    @Override
    public SQLType getSQLType(Class<?> javaType) {
        MysqlType mysqlType = DEFAULT_MYSQL_TYPES.get(javaType);
        if (mysqlType == null) {
            return DEFAULT_MYSQL_TYPES.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isAssignableFrom(javaType)).findFirst().map(Map.Entry::getValue).orElse(null);
        }
        return mysqlType;
    }

    @Override
    public String getLimitSQL(String sql, Integer rowCount, Integer offset) {
        String limitClauses = rowCount == null ? "" : (offset == null || offset == 0 ? " LIMIT " + rowCount : " LIMIT " + offset + "," + rowCount);
        return sql + limitClauses;
    }

    public String getDataTypeDefinition(ColumnInfo column) {
        if (StringUtils.notEmpty((String)column.type())) {
            return column.type();
        }
        return this.getDataTypeDefinitionByClass(column.javaField().getType());
    }

    static {
        DEFAULT_MYSQL_TYPES.put(Byte.TYPE, MysqlType.TINYINT);
        DEFAULT_MYSQL_TYPES.put(Byte[].class, MysqlType.BINARY);
        DEFAULT_MYSQL_TYPES.put(Double.TYPE, MysqlType.DOUBLE);
        DEFAULT_MYSQL_TYPES.put(Float.TYPE, MysqlType.FLOAT);
        DEFAULT_MYSQL_TYPES.put(Integer.TYPE, MysqlType.INT);
        DEFAULT_MYSQL_TYPES.put(Long.TYPE, MysqlType.BIGINT);
        DEFAULT_MYSQL_TYPES.put(Short.TYPE, MysqlType.SMALLINT);
        DEFAULT_MYSQL_TYPES.put(Boolean.TYPE, MysqlType.BOOLEAN);
        try {
            Field f = NativeQueryBindings.class.getDeclaredField("DEFAULT_MYSQL_TYPES");
            f.setAccessible(true);
            Map mysqlDriverDefaultMysqlTypes = (Map)f.get(null);
            DEFAULT_MYSQL_TYPES.putAll(mysqlDriverDefaultMysqlTypes);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

