/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.dao.group_by;

import cool.scx.dao.group_by.GroupByBody;
import cool.scx.dao.group_by.GroupByOption;
import cool.scx.dao.mapping.TableInfo;
import java.util.ArrayList;
import java.util.List;

public final class GroupBy {
    private final List<GroupByBody> groupByBodyList;

    public GroupBy() {
        this.groupByBodyList = new ArrayList<GroupByBody>();
    }

    public GroupBy(GroupBy oldGroupBy) {
        this.groupByBodyList = new ArrayList<GroupByBody>(oldGroupBy.groupByBodyList);
    }

    public GroupBy add(String name, GroupByOption ... options) {
        GroupByOption.Info info = new GroupByOption.Info(options);
        GroupByBody groupByBody = new GroupByBody(name, info);
        this.groupByBodyList.add(groupByBody);
        return this;
    }

    public GroupBy remove(String name) {
        this.groupByBodyList.removeIf(w -> w.name().equals(name.trim()));
        return this;
    }

    public GroupBy clear() {
        this.groupByBodyList.clear();
        return this;
    }

    public String[] getGroupByColumns(TableInfo<?> tableInfo) {
        return (String[])this.groupByBodyList.stream().map(c -> c.groupByColumn(tableInfo)).distinct().toArray(String[]::new);
    }
}

