/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.dao.impl;

import cool.scx.dao.annotation.Column;
import cool.scx.dao.mapping.ColumnInfo;
import cool.scx.util.CaseUtils;
import cool.scx.util.StringUtils;
import java.lang.reflect.Field;

public class AnnotationConfigColumnInfo
implements ColumnInfo {
    private final Field javaField;
    private final String columnName;
    private final String type;
    private final boolean needIndex;
    private final boolean unique;
    private final String onUpdateValue;
    private final String defaultValue;
    private final boolean primaryKey;
    private final boolean autoIncrement;
    private final boolean notNull;

    public AnnotationConfigColumnInfo(Field javaField) {
        this.javaField = javaField;
        Column column = javaField.getAnnotation(Column.class);
        if (column != null) {
            this.type = StringUtils.notBlank((String)column.type()) ? column.type() : null;
            this.columnName = StringUtils.notBlank((String)column.columnName()) ? column.columnName() : CaseUtils.toSnake((String)javaField.getName());
            this.needIndex = column.needIndex();
            this.unique = column.unique();
            this.onUpdateValue = column.onUpdateValue();
            this.defaultValue = column.defaultValue();
            this.primaryKey = column.primaryKey();
            this.autoIncrement = column.autoIncrement();
            this.notNull = column.notNull();
        } else {
            this.type = null;
            this.columnName = CaseUtils.toSnake((String)javaField.getName());
            this.needIndex = false;
            this.unique = false;
            this.onUpdateValue = null;
            this.defaultValue = null;
            this.primaryKey = false;
            this.autoIncrement = false;
            this.notNull = false;
        }
        this.javaField.setAccessible(true);
    }

    @Override
    public Field javaField() {
        return this.javaField;
    }

    public boolean notNull() {
        return this.notNull;
    }

    @Override
    public boolean primaryKey() {
        return this.primaryKey;
    }

    public boolean autoIncrement() {
        return this.autoIncrement;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public String onUpdateValue() {
        return this.onUpdateValue;
    }

    @Override
    public String columnName() {
        return this.columnName;
    }

    public String typeName() {
        return null;
    }

    public Integer columnSize() {
        return null;
    }

    @Override
    public String type() {
        return this.type;
    }

    public boolean unique() {
        return this.unique;
    }

    @Override
    public boolean needIndex() {
        return this.needIndex;
    }
}

