/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.dao.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.mysql.cj.xdevapi.AddResult;
import com.mysql.cj.xdevapi.DbDoc;
import com.mysql.cj.xdevapi.DocResult;
import com.mysql.cj.xdevapi.FindStatement;
import com.mysql.cj.xdevapi.JsonParser;
import com.mysql.cj.xdevapi.ModifyStatement;
import com.mysql.cj.xdevapi.RemoveStatement;
import com.mysql.cj.xdevapi.Result;
import com.mysql.cj.xdevapi.Schema;
import com.mysql.cj.xdevapi.Session;
import cool.scx.dao.BaseDao;
import cool.scx.dao.Query;
import cool.scx.dao.SelectFilter;
import cool.scx.dao.UpdateFilter;
import cool.scx.dao.impl.MySQLXDaoTableInfo;
import cool.scx.dao.where.WhereParamsAndWhereClauses;
import cool.scx.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MySQLXDao<Entity>
implements BaseDao<Entity, String> {
    private final Session session;
    private final Schema schema;
    private final com.mysql.cj.xdevapi.Collection collection;
    private final Class<Entity> entityClass;
    private final MySQLXDaoTableInfo tableInfo;

    public MySQLXDao(Class<Entity> entityClass, String tableName, Session session) {
        this.entityClass = entityClass;
        this.session = session;
        this.schema = session.getDefaultSchema();
        this.collection = this.schema.createCollection(tableName, true);
        this.tableInfo = new MySQLXDaoTableInfo(entityClass);
    }

    @Override
    public String insert(Entity entity, UpdateFilter updateFilter) {
        DbDoc dbDoc = this.toDbDoc(entity, updateFilter);
        AddResult execute = (AddResult)this.collection.add(dbDoc).execute();
        List generatedIds = execute.getGeneratedIds();
        return (String)generatedIds.get(0);
    }

    @Override
    public List<String> insertBatch(Collection<Entity> entityList, UpdateFilter updateFilter) {
        DbDoc[] dbDocs = (DbDoc[])entityList.stream().map(entity -> this.toDbDoc(entity, updateFilter)).toArray(DbDoc[]::new);
        AddResult execute = (AddResult)this.collection.add(dbDocs).execute();
        return execute.getGeneratedIds();
    }

    @Override
    public List<Entity> select(Query query, SelectFilter selectFilter) {
        WhereParamsAndWhereClauses whereParamsAndWhereClauses = query.where().getWhereParamsAndWhereClauses(this.tableInfo);
        String findStr = String.join((CharSequence)" AND ", whereParamsAndWhereClauses.whereClause());
        FindStatement findStatement = (FindStatement)this.collection.find(findStr).bind(whereParamsAndWhereClauses.whereParams());
        if (query.pagination().offset() != null) {
            findStatement.offset((long)query.pagination().offset().intValue());
        }
        if (query.pagination().rowCount() != null) {
            findStatement.limit((long)query.pagination().rowCount().intValue());
        }
        DocResult docResult = (DocResult)findStatement.execute();
        List dbDocs = docResult.fetchAll();
        ArrayList<Entity> s = new ArrayList<Entity>();
        for (DbDoc dbDoc : dbDocs) {
            s.add(this.toEntity(dbDoc));
        }
        return s;
    }

    @Override
    public long update(Entity entity, Query query, UpdateFilter updateFilter) {
        WhereParamsAndWhereClauses whereParamsAndWhereClauses = query.where().getWhereParamsAndWhereClauses(this.tableInfo);
        String findStr = String.join((CharSequence)" AND ", whereParamsAndWhereClauses.whereClause());
        DbDoc newDoc = this.toDbDoc(entity, updateFilter);
        Result result = (Result)((ModifyStatement)this.collection.modify(findStr).bind(whereParamsAndWhereClauses.whereParams())).patch(newDoc).execute();
        return result.getAffectedItemsCount();
    }

    @Override
    public long delete(Query query) {
        WhereParamsAndWhereClauses whereParamsAndWhereClauses = query.where().getWhereParamsAndWhereClauses(this.tableInfo);
        String findStr = String.join((CharSequence)" AND ", whereParamsAndWhereClauses.whereClause());
        Result result = (Result)((RemoveStatement)this.collection.remove(findStr).bind(whereParamsAndWhereClauses.whereParams())).execute();
        return result.getAffectedItemsCount();
    }

    @Override
    public long count(Query query) {
        WhereParamsAndWhereClauses whereParamsAndWhereClauses = query.where().getWhereParamsAndWhereClauses(this.tableInfo);
        String findStr = String.join((CharSequence)" AND ", whereParamsAndWhereClauses.whereClause());
        FindStatement findStatement = (FindStatement)this.collection.find(findStr).bind(whereParamsAndWhereClauses.whereParams());
        return ((DocResult)findStatement.execute()).count();
    }

    @Override
    public Class<Entity> _entityClass() {
        return this.entityClass;
    }

    public DbDoc toDbDoc(Object entity, UpdateFilter updateFilter) {
        String json = null;
        try {
            json = ObjectUtils.toJson((Object)entity, (ObjectUtils.Option[])new ObjectUtils.Option[0]);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return JsonParser.parseDoc((String)json);
    }

    public Entity toEntity(DbDoc dbDoc) {
        Object entity = null;
        try {
            String json = dbDoc.toString();
            entity = ObjectUtils.jsonMapper((ObjectUtils.Option[])new ObjectUtils.Option[0]).readValue(json, this.entityClass);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return (Entity)entity;
    }
}

