/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.dao.impl;

import cool.scx.dao.annotation.NoColumn;
import cool.scx.dao.annotation.Table;
import cool.scx.dao.impl.MySQLXDaoColumnInfo;
import cool.scx.dao.mapping.ColumnInfo;
import cool.scx.dao.mapping.TableInfo;
import cool.scx.sql.meta_data.PrimaryKeyMetaData;
import cool.scx.util.CaseUtils;
import cool.scx.util.MultiMap;
import cool.scx.util.StringUtils;
import cool.scx.util.reflect.FieldUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public final class MySQLXDaoTableInfo
implements TableInfo<MySQLXDaoColumnInfo> {
    private final MySQLXDaoColumnInfo[] columnInfos;
    private final String tableName;
    private final Map<String, MySQLXDaoColumnInfo> columnInfoMap;

    public MySQLXDaoTableInfo(Class<?> clazz) {
        this.tableName = MySQLXDaoTableInfo.initTableName(clazz);
        this.columnInfos = MySQLXDaoTableInfo.initAllColumnInfos(clazz);
        this.columnInfoMap = MySQLXDaoTableInfo.initAllColumnInfoMap(this.columnInfos);
    }

    private static MySQLXDaoColumnInfo[] initAllColumnInfos(Class<?> clazz) {
        List<MySQLXDaoColumnInfo> list = Stream.of(FieldUtils.findFields(clazz)).filter(field -> !field.isAnnotationPresent(NoColumn.class)).map(MySQLXDaoColumnInfo::new).toList();
        MySQLXDaoTableInfo.checkDuplicateColumnName(list, clazz);
        return (MySQLXDaoColumnInfo[])list.toArray(MySQLXDaoColumnInfo[]::new);
    }

    private static Map<String, MySQLXDaoColumnInfo> initAllColumnInfoMap(MySQLXDaoColumnInfo[] infos) {
        HashMap<String, MySQLXDaoColumnInfo> map = new HashMap<String, MySQLXDaoColumnInfo>();
        for (MySQLXDaoColumnInfo info : infos) {
            map.put(info.columnName(), info);
        }
        for (MySQLXDaoColumnInfo info : infos) {
            map.put(info.javaFieldName(), info);
        }
        return map;
    }

    private static void checkDuplicateColumnName(List<MySQLXDaoColumnInfo> list, Class<?> clazz) {
        MultiMap multiMap = new MultiMap();
        for (MySQLXDaoColumnInfo info : list) {
            multiMap.put((Object)info.columnName(), (Object)info);
        }
        Map map = multiMap.toMultiValueMap();
        for (Map.Entry entry : map.entrySet()) {
            List v = (List)entry.getValue();
            if (v.size() <= 1) continue;
            throw new IllegalArgumentException("\u91cd\u590d\u7684 columnName !!! Class -> " + clazz.getName() + ", Field -> " + v.stream().map(ColumnInfo::javaFieldName).toList());
        }
    }

    private static String initTableName(Class<?> clazz) {
        Table scxModel = clazz.getAnnotation(Table.class);
        if (scxModel != null && StringUtils.notBlank((String)scxModel.tableName())) {
            return scxModel.tableName();
        }
        if (scxModel != null && StringUtils.notBlank((String)scxModel.tablePrefix())) {
            return scxModel.tablePrefix() + "_" + CaseUtils.toSnake((String)clazz.getSimpleName());
        }
        return "scx_" + CaseUtils.toSnake((String)clazz.getSimpleName());
    }

    public String tableName() {
        return this.tableName;
    }

    public MySQLXDaoColumnInfo[] columns() {
        return this.columnInfos;
    }

    public PrimaryKeyMetaData[] primaryKeys() {
        return new PrimaryKeyMetaData[0];
    }

    public MySQLXDaoColumnInfo getColumn(String javaFieldName) {
        return this.columnInfoMap.get(javaFieldName);
    }
}

