/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.dao;

import cool.scx.dao.BaseDaoColumnInfo;
import cool.scx.dao.BaseDaoTableInfo;
import cool.scx.dao.Query;
import cool.scx.dao.SelectFilter;
import cool.scx.dao.UpdateFilter;
import cool.scx.dao.where.WhereParamsAndWhereClauses;
import cool.scx.sql.ColumnInfo;
import cool.scx.sql.ResultHandler;
import cool.scx.sql.SQL;
import cool.scx.sql.SQLBuilder;
import cool.scx.sql.SQLRunner;
import cool.scx.sql.TableInfo;
import cool.scx.sql.result_handler.BeanListHandler;
import cool.scx.sql.result_handler.SingleValueHandler;
import cool.scx.util.RandomUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class BaseDao<Entity> {
    protected final BaseDaoTableInfo<?> tableInfo;
    protected final Class<Entity> entityClass;
    protected final SQLRunner sqlRunner;
    protected final ResultHandler<List<Entity>> entityBeanListHandler;
    protected final ResultHandler<Long> countResultHandler;

    public BaseDao(BaseDaoTableInfo<? extends BaseDaoColumnInfo> tableInfo, Class<Entity> entityClass, SQLRunner sqlRunner) {
        this.tableInfo = tableInfo;
        this.entityClass = entityClass;
        this.sqlRunner = sqlRunner;
        this.entityBeanListHandler = new BeanListHandler(this.entityClass);
        this.countResultHandler = new SingleValueHandler("count", Long.class);
    }

    public final Long insert(Entity entity, UpdateFilter updateFilter) {
        return this.sqlRunner.update(this._buildInsertSQL(entity, updateFilter)).firstGeneratedKey();
    }

    private SQL _buildInsertSQL(Entity entity, UpdateFilter updateFilter) {
        BaseDaoColumnInfo[] insertColumnInfos = updateFilter.filter(entity, (BaseDaoColumnInfo[])this.tableInfo.columnInfos());
        String[] insertColumns = (String[])Arrays.stream(insertColumnInfos).map(ColumnInfo::columnName).toArray(String[]::new);
        String[] insertValues = (String[])Arrays.stream(insertColumnInfos).map(BaseDaoColumnInfo::insertValuesSQL).toArray(String[]::new);
        String sql = SQLBuilder.Insert((String)this.tableInfo.tableName(), (String[])insertColumns).Values(insertValues).GetSQL();
        Object[] objectArray = Arrays.stream(insertColumnInfos).map(c -> c.javaFieldValue(entity)).toArray();
        return SQL.ofPlaceholder((String)sql, (Object[])objectArray);
    }

    public final List<Long> insertBatch(Collection<Entity> entityList, UpdateFilter updateFilter) {
        return this.sqlRunner.updateBatch(this.buildInsertBatchSQL(entityList, updateFilter)).generatedKeys();
    }

    private SQL buildInsertBatchSQL(Collection<Entity> entityList, UpdateFilter updateFilter) {
        BaseDaoColumnInfo[] insertColumnInfos = updateFilter.filter((BaseDaoColumnInfo[])this.tableInfo.columnInfos());
        ArrayList<Object[]> objectArrayList = new ArrayList<Object[]>();
        for (Entity entity : entityList) {
            Object[] o = new Object[insertColumnInfos.length];
            for (int i = 0; i < insertColumnInfos.length; ++i) {
                o[i] = insertColumnInfos[i].javaFieldValue(entity);
            }
            objectArrayList.add(o);
        }
        String[] insertColumns = (String[])Arrays.stream(insertColumnInfos).map(ColumnInfo::columnName).toArray(String[]::new);
        String[] insertValues = (String[])Arrays.stream(insertColumnInfos).map(BaseDaoColumnInfo::insertValuesSQL).toArray(String[]::new);
        String sql = SQLBuilder.Insert((String)this.tableInfo.tableName(), (String[])insertColumns).Values(insertValues).GetSQL();
        return SQL.ofPlaceholder((String)sql, objectArrayList);
    }

    public final List<Entity> select(Query query, SelectFilter selectFilter) {
        return (List)this.sqlRunner.query(this.buildSelectSQL(query, selectFilter), this.entityBeanListHandler);
    }

    public final SQL buildSelectSQL(Query query, SelectFilter selectFilter) {
        BaseDaoColumnInfo[] selectColumnInfos = selectFilter.filter((BaseDaoColumnInfo[])this.tableInfo.columnInfos());
        String[] selectColumns = (String[])Arrays.stream(selectColumnInfos).map(BaseDaoColumnInfo::selectSQL).toArray(String[]::new);
        WhereParamsAndWhereClauses whereParamsAndWhereClauses = query.where().getWhereParamsAndWhereClauses(this.tableInfo);
        String[] groupByColumns = query.groupBy().getGroupByColumns(this.tableInfo);
        String[] orderByClauses = query.orderBy().getOrderByClauses(this.tableInfo);
        String sql = SQLBuilder.Select((String[])selectColumns).From(this.tableInfo.tableName()).Where(whereParamsAndWhereClauses.whereClause()).GroupBy(groupByColumns).OrderBy(orderByClauses).Limit(query.pagination().offset(), query.pagination().rowCount()).GetSQL();
        return SQL.ofPlaceholder((String)sql, (Object[])whereParamsAndWhereClauses.whereParams());
    }

    public final SQL buildSelectSQLWithAlias(Query query, SelectFilter selectFilter) {
        if (query.pagination().rowCount() == null) {
            return this.buildSelectSQL(query, selectFilter);
        }
        BaseDaoColumnInfo[] selectColumnInfos = selectFilter.filter((BaseDaoColumnInfo[])this.tableInfo.columnInfos());
        String[] selectColumns = (String[])Arrays.stream(selectColumnInfos).map(BaseDaoColumnInfo::selectSQL).toArray(String[]::new);
        WhereParamsAndWhereClauses whereParamsAndWhereClauses = query.where().getWhereParamsAndWhereClauses(this.tableInfo);
        String[] groupByColumns = query.groupBy().getGroupByColumns(this.tableInfo);
        String[] orderByClauses = query.orderBy().getOrderByClauses(this.tableInfo);
        String sql0 = SQLBuilder.Select((String[])selectColumns).From(this.tableInfo.tableName()).Where(whereParamsAndWhereClauses.whereClause()).GroupBy(groupByColumns).OrderBy(orderByClauses).Limit(query.pagination().offset(), query.pagination().rowCount()).GetSQL();
        String sql = SQLBuilder.Select((String[])((String[])Arrays.stream(selectColumnInfos).map(BaseDaoColumnInfo::javaFieldName).toArray(String[]::new))).From("(" + sql0 + ")").GetSQL();
        return SQL.ofPlaceholder((String)(sql + " AS " + this.tableInfo.tableName() + "_" + RandomUtils.randomString((int)6)), (Object[])whereParamsAndWhereClauses.whereParams());
    }

    public final long count(Query query) {
        return (Long)this.sqlRunner.query(this.buildCountSQL(query), this.countResultHandler);
    }

    private SQL buildCountSQL(Query query) {
        WhereParamsAndWhereClauses whereParamsAndWhereClauses = query.where().getWhereParamsAndWhereClauses(this.tableInfo);
        String[] groupByColumns = query.groupBy().getGroupByColumns(this.tableInfo);
        String sql = SQLBuilder.Select((String[])new String[]{"COUNT(*) AS count"}).From(this.tableInfo.tableName()).Where(whereParamsAndWhereClauses.whereClause()).GroupBy(groupByColumns).GetSQL();
        return SQL.ofPlaceholder((String)sql, (Object[])whereParamsAndWhereClauses.whereParams());
    }

    public final long update(Entity entity, Query query, UpdateFilter updateFilter) {
        return this.sqlRunner.update(this.buildUpdateSQL(entity, query, updateFilter)).affectedItemsCount();
    }

    private SQL buildUpdateSQL(Entity entity, Query query, UpdateFilter updateFilter) {
        if (query.where().isEmpty()) {
            throw new IllegalArgumentException("\u66f4\u65b0\u6570\u636e\u65f6 \u5fc5\u987b\u6307\u5b9a \u5220\u9664\u6761\u4ef6 \u6216 \u81ea\u5b9a\u4e49\u7684 where \u8bed\u53e5 !!!");
        }
        BaseDaoColumnInfo[] updateSetColumnInfos = updateFilter.filter(entity, (BaseDaoColumnInfo[])this.tableInfo.columnInfos());
        String[] updateSetColumns = (String[])Arrays.stream(updateSetColumnInfos).map(BaseDaoColumnInfo::updateSetSQL).toArray(String[]::new);
        WhereParamsAndWhereClauses whereParamsAndWhereClauses = query.where().getWhereParamsAndWhereClauses(this.tableInfo);
        String sql = SQLBuilder.Update((String)this.tableInfo.tableName()).Set(updateSetColumns).Where(whereParamsAndWhereClauses.whereClause()).GetSQL();
        List entityParams = Arrays.stream(updateSetColumnInfos).map(c -> c.javaFieldValue(entity)).collect(Collectors.toList());
        entityParams.addAll(List.of(whereParamsAndWhereClauses.whereParams()));
        return SQL.ofPlaceholder((String)sql, (Object[])entityParams.toArray());
    }

    public final long delete(Query query) {
        return this.sqlRunner.update(this.buildDeleteSQL(query)).affectedItemsCount();
    }

    private SQL buildDeleteSQL(Query query) {
        if (query.where().isEmpty()) {
            throw new IllegalArgumentException("\u5220\u9664\u6570\u636e\u65f6 \u5fc5\u987b\u6307\u5b9a \u5220\u9664\u6761\u4ef6 \u6216 \u81ea\u5b9a\u4e49\u7684 where \u8bed\u53e5 !!!");
        }
        WhereParamsAndWhereClauses whereParamsAndWhereClauses = query.where().getWhereParamsAndWhereClauses(this.tableInfo);
        String sql = SQLBuilder.Delete((String)this.tableInfo.tableName()).Where(whereParamsAndWhereClauses.whereClause()).GetSQL();
        return SQL.ofPlaceholder((String)sql, (Object[])whereParamsAndWhereClauses.whereParams());
    }

    public final void _truncate() {
        this.sqlRunner.execute(SQL.ofNormal((String)("truncate " + this.tableInfo.tableName())));
    }

    public final TableInfo<? extends BaseDaoColumnInfo> _tableInfo() {
        return this.tableInfo;
    }

    public final Class<Entity> _entityClass() {
        return this.entityClass;
    }

    public final SQLRunner _sqlRunner() {
        return this.sqlRunner;
    }
}

