/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.dao;

import cool.scx.dao.BaseDaoColumnInfo;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public abstract class ColumnInfoFilter<E extends ColumnInfoFilter<E>> {
    private final Set<String> fieldNames = new HashSet<String>();
    private final FilterMode filterMode;

    protected ColumnInfoFilter(FilterMode filterMode) {
        this.filterMode = filterMode;
    }

    private E _addFieldNames(String ... fieldNames) {
        this.fieldNames.addAll(Arrays.asList(fieldNames));
        return this.self();
    }

    private E _removeFieldNames(String ... fieldNames) {
        for (String fieldName : fieldNames) {
            this.fieldNames.remove(fieldName);
        }
        return this.self();
    }

    public final E addIncluded(String ... fieldNames) {
        return switch (this.filterMode) {
            default -> throw new IncompatibleClassChangeError();
            case FilterMode.INCLUDED -> this._addFieldNames(fieldNames);
            case FilterMode.EXCLUDED -> this._removeFieldNames(fieldNames);
        };
    }

    public final E addExcluded(String ... fieldNames) {
        return switch (this.filterMode) {
            default -> throw new IncompatibleClassChangeError();
            case FilterMode.EXCLUDED -> this._addFieldNames(fieldNames);
            case FilterMode.INCLUDED -> this._removeFieldNames(fieldNames);
        };
    }

    public final E removeIncluded(String ... fieldNames) {
        return this.addExcluded(fieldNames);
    }

    public final E removeExcluded(String ... fieldNames) {
        return this.addIncluded(fieldNames);
    }

    public final E clear() {
        this.fieldNames.clear();
        return this.self();
    }

    public final BaseDaoColumnInfo[] filter(BaseDaoColumnInfo ... scxDaoColumnInfos) {
        BaseDaoColumnInfo[] baseDaoColumnInfoArray;
        if (this.fieldNames.size() == 0) {
            switch (this.filterMode) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case INCLUDED: {
                    baseDaoColumnInfoArray = new BaseDaoColumnInfo[]{};
                    break;
                }
                case EXCLUDED: {
                    baseDaoColumnInfoArray = scxDaoColumnInfos;
                    break;
                }
            }
        } else {
            switch (this.filterMode) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case INCLUDED: {
                    baseDaoColumnInfoArray = (BaseDaoColumnInfo[])Arrays.stream(scxDaoColumnInfos).filter((? super T c) -> this.fieldNames.contains(c.javaFieldName())).toArray(BaseDaoColumnInfo[]::new);
                    break;
                }
                case EXCLUDED: {
                    baseDaoColumnInfoArray = (BaseDaoColumnInfo[])Arrays.stream(scxDaoColumnInfos).filter((? super T c) -> !this.fieldNames.contains(c.javaFieldName())).toArray(BaseDaoColumnInfo[]::new);
                }
            }
        }
        return baseDaoColumnInfoArray;
    }

    public FilterMode filterMode() {
        return this.filterMode;
    }

    private E self() {
        return (E)this;
    }

    public static enum FilterMode {
        INCLUDED,
        EXCLUDED;


        public static FilterMode of(String filterModeStr) {
            return FilterMode.valueOf(filterModeStr.trim().toUpperCase());
        }
    }
}

