/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.dao.impl;

import cool.scx.dao.AnnotationConfigColumn;
import cool.scx.dao.AnnotationConfigTable;
import cool.scx.dao.BaseDao;
import cool.scx.dao.ColumnFilter;
import cool.scx.dao.ColumnMapping;
import cool.scx.dao.Query;
import cool.scx.dao.dialect.Dialect;
import cool.scx.dao.dialect.DialectSelector;
import cool.scx.dao.impl.ColumnNameParser;
import cool.scx.dao.impl.SQLBuilder;
import cool.scx.dao.impl.WhereParamsAndWhereClause;
import cool.scx.dao.impl.WhereParamsAndWhereClauses;
import cool.scx.dao.impl.WhereTypeHandler;
import cool.scx.dao.query.GroupBy;
import cool.scx.dao.query.GroupByBody;
import cool.scx.dao.query.OrderBy;
import cool.scx.dao.query.OrderByBody;
import cool.scx.dao.query.Where;
import cool.scx.dao.query.WhereBody;
import cool.scx.sql.SQLRunner;
import cool.scx.sql.mapping.Column;
import cool.scx.sql.mapping.Table;
import cool.scx.sql.result_handler.ResultHandler;
import cool.scx.sql.sql.SQL;
import cool.scx.util.RandomUtils;
import cool.scx.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;

public class SQLDao<Entity>
implements BaseDao<Entity, Long> {
    protected final AnnotationConfigTable tableInfo;
    protected final Class<Entity> entityClass;
    protected final SQLRunner sqlRunner;
    protected final ResultHandler<List<Entity>> entityBeanListHandler;
    protected final ResultHandler<Long> countResultHandler;
    protected final Dialect dialect;

    public SQLDao(Class<Entity> entityClass, DataSource dataSource) {
        this.entityClass = entityClass;
        this.dialect = DialectSelector.findDialect(dataSource);
        this.tableInfo = new AnnotationConfigTable(entityClass);
        this.sqlRunner = new SQLRunner(dataSource);
        this.entityBeanListHandler = ResultHandler.ofBeanList(this.entityClass, field -> {
            AnnotationConfigColumn columnInfo = this.tableInfo.getColumn(field.getName());
            return columnInfo == null ? null : columnInfo.name();
        });
        this.countResultHandler = ResultHandler.ofSingleValue((String)"count", Long.class);
    }

    public static String[] getGroupByColumns(GroupBy groupBy, Table<?> tableInfo) {
        return (String[])groupBy.groupByBodyList().stream().map(c -> SQLDao.groupByColumn(c, tableInfo)).distinct().toArray(String[]::new);
    }

    static String groupByColumn(GroupByBody body, Table<?> tableInfo) {
        return ColumnNameParser.parseColumnName(tableInfo, body.name(), body.info().useJsonExtract(), body.info().useOriginalName());
    }

    public static String[] getOrderByClauses(OrderBy orderBy, Table<?> tableInfo) {
        return (String[])orderBy.orderByBodyList().stream().map(c -> SQLDao.orderByClause(c, tableInfo)).toArray(String[]::new);
    }

    static String orderByClause(OrderByBody body, Table<?> tableInfo) {
        String columnName = ColumnNameParser.parseColumnName(tableInfo, body.name(), body.info().useJsonExtract(), body.info().useOriginalName());
        return columnName + " " + body.orderByType().name();
    }

    public static WhereParamsAndWhereClauses getWhereParamsAndWhereClauses(Where where, Table<?> tableInfo) {
        ArrayList<String> whereClauses = new ArrayList<String>();
        ArrayList<Object> whereParams = new ArrayList<Object>();
        for (WhereBody whereBody : where.whereBodyList()) {
            WhereParamsAndWhereClause whereParamsAndWhereClause = SQLDao.getWhereParamsAndWhereClause(whereBody, tableInfo);
            whereClauses.add(whereParamsAndWhereClause.whereClause());
            whereParams.addAll(List.of(whereParamsAndWhereClause.whereParams()));
        }
        StringBuilder tempWhereSQL = new StringBuilder();
        for (Object o : where.whereSQL()) {
            if (o instanceof String) {
                String s = (String)o;
                tempWhereSQL.append(s);
                continue;
            }
            if (o instanceof WhereBody) {
                WhereBody w = (WhereBody)o;
                WhereParamsAndWhereClause whereParamsAndWhereClause = SQLDao.getWhereParamsAndWhereClause(w, tableInfo);
                tempWhereSQL.append(whereParamsAndWhereClause.whereClause());
                whereParams.addAll(List.of(whereParamsAndWhereClause.whereParams()));
                continue;
            }
            if (!(o instanceof SQL)) continue;
            SQL a = (SQL)o;
            tempWhereSQL.append("(").append(a.sql()).append(")");
            whereParams.addAll(List.of(a.params()));
        }
        String string = tempWhereSQL.toString();
        if (StringUtils.notBlank((String)string)) {
            whereClauses.add(string);
        }
        return new WhereParamsAndWhereClauses(whereParams.toArray(), (String[])whereClauses.toArray(String[]::new));
    }

    public static WhereParamsAndWhereClause getWhereParamsAndWhereClause(WhereBody body, Table<?> tableInfo) {
        return WhereTypeHandler.findWhereTypeHandler(body.whereType()).getWhereParamsAndWhereClause(tableInfo, body.name(), body.whereType(), body.value1(), body.value2(), body.info());
    }

    @Override
    public final Long insert(Entity entity, ColumnFilter updateFilter) {
        return this.sqlRunner.update(this._buildInsertSQL(entity, updateFilter)).firstGeneratedKey();
    }

    private SQL _buildInsertSQL(Entity entity, ColumnFilter updateFilter) {
        ColumnMapping[] insertColumnInfos = updateFilter.filter(entity, this.tableInfo);
        String[] insertColumns = (String[])Arrays.stream(insertColumnInfos).map(Column::name).toArray(String[]::new);
        String[] insertValues = (String[])Arrays.stream(insertColumnInfos).map(columnInfo -> "?").toArray(String[]::new);
        String sql = SQLBuilder.Insert(this.dialect, this.tableInfo.name(), insertColumns).Values(insertValues).GetSQL();
        Object[] objectArray = Arrays.stream(insertColumnInfos).map(c -> c.javaFieldValue(entity)).toArray();
        return SQL.ofPlaceholder((String)sql, (Object[])objectArray);
    }

    @Override
    public final List<Long> insertBatch(Collection<Entity> entityList, ColumnFilter updateFilter) {
        return this.sqlRunner.updateBatch(this.buildInsertBatchSQL(entityList, updateFilter)).generatedKeys();
    }

    private SQL buildInsertBatchSQL(Collection<Entity> entityList, ColumnFilter updateFilter) {
        ColumnMapping[] insertColumnInfos = updateFilter.filter(this.tableInfo);
        ArrayList<Object[]> objectArrayList = new ArrayList<Object[]>();
        for (Entity entity : entityList) {
            Object[] o = new Object[insertColumnInfos.length];
            for (int i = 0; i < insertColumnInfos.length; ++i) {
                o[i] = insertColumnInfos[i].javaFieldValue(entity);
            }
            objectArrayList.add(o);
        }
        String[] insertColumns = (String[])Arrays.stream(insertColumnInfos).map(Column::name).toArray(String[]::new);
        String[] insertValues = (String[])Arrays.stream(insertColumnInfos).map(c -> "?").toArray(String[]::new);
        String sql = SQLBuilder.Insert(this.dialect, this.tableInfo.name(), insertColumns).Values(insertValues).GetSQL();
        return SQL.ofPlaceholder((String)sql, objectArrayList);
    }

    @Override
    public final List<Entity> select(Query query, ColumnFilter selectFilter) {
        return (List)this.sqlRunner.query(this.buildSelectSQL(query, selectFilter), this.entityBeanListHandler);
    }

    public final SQL buildSelectSQL(Query query, ColumnFilter selectFilter) {
        ColumnMapping[] selectColumnInfos = selectFilter.filter(this.tableInfo);
        String[] selectColumns = (String[])Arrays.stream(selectColumnInfos).map(Column::name).toArray(String[]::new);
        WhereParamsAndWhereClauses whereParamsAndWhereClauses = SQLDao.getWhereParamsAndWhereClauses(query.where(), this.tableInfo);
        String[] groupByColumns = SQLDao.getGroupByColumns(query.groupBy(), this.tableInfo);
        String[] orderByClauses = SQLDao.getOrderByClauses(query.orderBy(), this.tableInfo);
        String sql = SQLBuilder.Select(this.dialect, selectColumns).From(this.tableInfo.name()).Where(whereParamsAndWhereClauses.whereClause()).GroupBy(groupByColumns).OrderBy(orderByClauses).Limit(query.limit().offset(), query.limit().rowCount()).GetSQL();
        return SQL.ofPlaceholder((String)sql, (Object[])whereParamsAndWhereClauses.whereParams());
    }

    public final SQL buildSelectSQLWithAlias(Query query, ColumnFilter selectFilter) {
        if (query.limit().rowCount() == null) {
            return this.buildSelectSQL(query, selectFilter);
        }
        ColumnMapping[] selectColumnInfos = selectFilter.filter(this.tableInfo);
        String[] selectColumns = (String[])Arrays.stream(selectColumnInfos).map(Column::name).toArray(String[]::new);
        WhereParamsAndWhereClauses whereParamsAndWhereClauses = SQLDao.getWhereParamsAndWhereClauses(query.where(), this.tableInfo);
        String[] groupByColumns = SQLDao.getGroupByColumns(query.groupBy(), this.tableInfo);
        String[] orderByClauses = SQLDao.getOrderByClauses(query.orderBy(), this.tableInfo);
        String sql0 = SQLBuilder.Select(this.dialect, selectColumns).From(this.tableInfo.name()).Where(whereParamsAndWhereClauses.whereClause()).GroupBy(groupByColumns).OrderBy(orderByClauses).Limit(query.limit().offset(), query.limit().rowCount()).GetSQL();
        String sql = SQLBuilder.Select(this.dialect, "*").From("(" + sql0 + ")").GetSQL();
        return SQL.ofPlaceholder((String)(sql + " AS " + this.tableInfo.name() + "_" + RandomUtils.randomString((int)6)), (Object[])whereParamsAndWhereClauses.whereParams());
    }

    @Override
    public final long count(Query query) {
        return (Long)this.sqlRunner.query(this.buildCountSQL(query), this.countResultHandler);
    }

    private SQL buildCountSQL(Query query) {
        WhereParamsAndWhereClauses whereParamsAndWhereClauses = SQLDao.getWhereParamsAndWhereClauses(query.where(), this.tableInfo);
        String[] groupByColumns = SQLDao.getGroupByColumns(query.groupBy(), this.tableInfo);
        String sql = SQLBuilder.Select(this.dialect, "COUNT(*) AS count").From(this.tableInfo.name()).Where(whereParamsAndWhereClauses.whereClause()).GroupBy(groupByColumns).GetSQL();
        return SQL.ofPlaceholder((String)sql, (Object[])whereParamsAndWhereClauses.whereParams());
    }

    @Override
    public final long update(Entity entity, Query query, ColumnFilter updateFilter) {
        return this.sqlRunner.update(this.buildUpdateSQL(entity, query, updateFilter)).affectedItemsCount();
    }

    private SQL buildUpdateSQL(Entity entity, Query query, ColumnFilter updateFilter) {
        if (query.where().isEmpty()) {
            throw new IllegalArgumentException("\u66f4\u65b0\u6570\u636e\u65f6 \u5fc5\u987b\u6307\u5b9a \u5220\u9664\u6761\u4ef6 \u6216 \u81ea\u5b9a\u4e49\u7684 where \u8bed\u53e5 !!!");
        }
        ColumnMapping[] updateSetColumnInfos = updateFilter.filter(entity, this.tableInfo);
        String[] updateSetColumns = (String[])Arrays.stream(updateSetColumnInfos).map(c -> c.name() + " = ?").toArray(String[]::new);
        WhereParamsAndWhereClauses whereParamsAndWhereClauses = SQLDao.getWhereParamsAndWhereClauses(query.where(), this.tableInfo);
        String sql = SQLBuilder.Update(this.dialect, this.tableInfo.name()).Set(updateSetColumns).Where(whereParamsAndWhereClauses.whereClause()).GetSQL();
        List entityParams = Arrays.stream(updateSetColumnInfos).map(c -> c.javaFieldValue(entity)).collect(Collectors.toList());
        entityParams.addAll(List.of(whereParamsAndWhereClauses.whereParams()));
        return SQL.ofPlaceholder((String)sql, (Object[])entityParams.toArray());
    }

    @Override
    public final long delete(Query query) {
        return this.sqlRunner.update(this.buildDeleteSQL(query)).affectedItemsCount();
    }

    private SQL buildDeleteSQL(Query query) {
        if (query.where().isEmpty()) {
            throw new IllegalArgumentException("\u5220\u9664\u6570\u636e\u65f6 \u5fc5\u987b\u6307\u5b9a \u5220\u9664\u6761\u4ef6 \u6216 \u81ea\u5b9a\u4e49\u7684 where \u8bed\u53e5 !!!");
        }
        WhereParamsAndWhereClauses whereParamsAndWhereClauses = SQLDao.getWhereParamsAndWhereClauses(query.where(), this.tableInfo);
        String sql = SQLBuilder.Delete(this.dialect, this.tableInfo.name()).Where(whereParamsAndWhereClauses.whereClause()).GetSQL();
        return SQL.ofPlaceholder((String)sql, (Object[])whereParamsAndWhereClauses.whereParams());
    }

    public final void _truncate() {
        this.sqlRunner.execute(SQL.ofNormal((String)("truncate " + this.tableInfo.name())));
    }

    public final Table<? extends ColumnMapping> _tableInfo() {
        return this.tableInfo;
    }

    @Override
    public final Class<Entity> _entityClass() {
        return this.entityClass;
    }

    public final SQLRunner _sqlRunner() {
        return this.sqlRunner;
    }
}

