/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.dao.impl.xdevapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.mysql.cj.xdevapi.AddResult;
import com.mysql.cj.xdevapi.DbDoc;
import com.mysql.cj.xdevapi.DocResult;
import com.mysql.cj.xdevapi.FindStatement;
import com.mysql.cj.xdevapi.JsonParser;
import com.mysql.cj.xdevapi.ModifyStatement;
import com.mysql.cj.xdevapi.RemoveStatement;
import com.mysql.cj.xdevapi.Result;
import com.mysql.cj.xdevapi.Schema;
import com.mysql.cj.xdevapi.Session;
import cool.scx.dao.AnnotationConfigTable;
import cool.scx.dao.BaseDao;
import cool.scx.dao.ColumnFilter;
import cool.scx.dao.Query;
import cool.scx.dao.impl.WhereParamsAndWhereClause;
import cool.scx.dao.impl.WhereParamsAndWhereClauses;
import cool.scx.dao.impl.xdevapi.WhereTypeHandler;
import cool.scx.dao.query.Where;
import cool.scx.dao.query.WhereBody;
import cool.scx.sql.sql.SQL;
import cool.scx.util.ObjectUtils;
import cool.scx.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MySQLXDao<Entity>
implements BaseDao<Entity, String> {
    private final Session session;
    private final Schema schema;
    private final com.mysql.cj.xdevapi.Collection collection;
    private final Class<Entity> entityClass;

    public MySQLXDao(Class<Entity> entityClass, Session session, String tableName) {
        this.entityClass = entityClass;
        this.session = session;
        this.schema = session.getDefaultSchema();
        this.collection = this.schema.createCollection(tableName, true);
    }

    public MySQLXDao(Class<Entity> entityClass, Session session) {
        this(entityClass, session, AnnotationConfigTable.initTableName(entityClass));
    }

    public static WhereParamsAndWhereClauses getWhereParamsAndWhereClauses(Where where) {
        ArrayList<String> whereClauses = new ArrayList<String>();
        ArrayList<Object> whereParams = new ArrayList<Object>();
        for (WhereBody whereBody : where.whereBodyList()) {
            WhereParamsAndWhereClause whereParamsAndWhereClause = MySQLXDao.getWhereParamsAndWhereClause(whereBody);
            whereClauses.add(whereParamsAndWhereClause.whereClause());
            whereParams.addAll(List.of(whereParamsAndWhereClause.whereParams()));
        }
        StringBuilder tempWhereSQL = new StringBuilder();
        for (Object o : where.whereSQL()) {
            if (o instanceof String) {
                String s = (String)o;
                tempWhereSQL.append(s);
                continue;
            }
            if (o instanceof WhereBody) {
                WhereBody w = (WhereBody)o;
                WhereParamsAndWhereClause whereParamsAndWhereClause = MySQLXDao.getWhereParamsAndWhereClause(w);
                tempWhereSQL.append(whereParamsAndWhereClause.whereClause());
                whereParams.addAll(List.of(whereParamsAndWhereClause.whereParams()));
                continue;
            }
            if (!(o instanceof SQL)) continue;
            SQL a = (SQL)o;
            tempWhereSQL.append("(").append(a.sql()).append(")");
            whereParams.addAll(List.of(a.params()));
        }
        String string = tempWhereSQL.toString();
        if (StringUtils.notBlank((String)string)) {
            whereClauses.add(string);
        }
        return new WhereParamsAndWhereClauses(whereParams.toArray(), (String[])whereClauses.toArray(String[]::new));
    }

    public static WhereParamsAndWhereClause getWhereParamsAndWhereClause(WhereBody body) {
        return WhereTypeHandler.findWhereTypeHandler(body.whereType()).getWhereParamsAndWhereClause(body.name(), body.whereType(), body.value1(), body.value2(), body.info());
    }

    @Override
    public String insert(Entity entity, ColumnFilter updateFilter) {
        DbDoc dbDoc = this.toDbDoc(entity, updateFilter);
        AddResult execute = (AddResult)this.collection.add(dbDoc).execute();
        List generatedIds = execute.getGeneratedIds();
        return (String)generatedIds.get(0);
    }

    @Override
    public List<String> insertBatch(Collection<Entity> entityList, ColumnFilter updateFilter) {
        DbDoc[] dbDocs = new DbDoc[entityList.size()];
        int index = 0;
        for (Entity entity : entityList) {
            dbDocs[index] = this.toDbDoc(entity, updateFilter);
            ++index;
        }
        AddResult execute = (AddResult)this.collection.add(dbDocs).execute();
        return execute.getGeneratedIds();
    }

    @Override
    public List<Entity> select(Query query, ColumnFilter selectFilter) {
        WhereParamsAndWhereClauses whereParamsAndWhereClauses = MySQLXDao.getWhereParamsAndWhereClauses(query.where());
        String findStr = String.join((CharSequence)" AND ", whereParamsAndWhereClauses.whereClause());
        FindStatement findStatement = (FindStatement)this.collection.find(findStr).bind(whereParamsAndWhereClauses.whereParams());
        if (query.limit().offset() != null) {
            findStatement.offset((long)query.limit().offset().intValue());
        }
        if (query.limit().rowCount() != null) {
            findStatement.limit((long)query.limit().rowCount().intValue());
        }
        DocResult docResult = (DocResult)findStatement.execute();
        List dbDocs = docResult.fetchAll();
        ArrayList<Entity> list = new ArrayList<Entity>();
        for (DbDoc dbDoc : dbDocs) {
            list.add(this.toEntity(dbDoc));
        }
        return list;
    }

    @Override
    public long update(Entity entity, Query query, ColumnFilter updateFilter) {
        WhereParamsAndWhereClauses whereParamsAndWhereClauses = MySQLXDao.getWhereParamsAndWhereClauses(query.where());
        String findStr = String.join((CharSequence)" AND ", whereParamsAndWhereClauses.whereClause());
        DbDoc newDoc = this.toDbDoc(entity, updateFilter);
        Result result = (Result)((ModifyStatement)this.collection.modify(findStr).bind(new Object[]{whereParamsAndWhereClauses})).patch(newDoc).execute();
        return result.getAffectedItemsCount();
    }

    @Override
    public long delete(Query query) {
        WhereParamsAndWhereClauses whereParamsAndWhereClauses = MySQLXDao.getWhereParamsAndWhereClauses(query.where());
        String findStr = String.join((CharSequence)" AND ", whereParamsAndWhereClauses.whereClause());
        Result result = (Result)((RemoveStatement)this.collection.remove(findStr).bind(whereParamsAndWhereClauses.whereParams())).execute();
        return result.getAffectedItemsCount();
    }

    @Override
    public long count(Query query) {
        WhereParamsAndWhereClauses whereParamsAndWhereClauses = MySQLXDao.getWhereParamsAndWhereClauses(query.where());
        String findStr = String.join((CharSequence)" AND ", whereParamsAndWhereClauses.whereClause());
        FindStatement findStatement = (FindStatement)this.collection.find(findStr).bind(whereParamsAndWhereClauses.whereParams());
        return ((DocResult)findStatement.execute()).count();
    }

    @Override
    public Class<Entity> _entityClass() {
        return this.entityClass;
    }

    public DbDoc toDbDoc(Object entity, ColumnFilter updateFilter) {
        String json = null;
        try {
            json = ObjectUtils.toJson((Object)entity, (ObjectUtils.Option[])new ObjectUtils.Option[0]);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return JsonParser.parseDoc((String)json);
    }

    public Entity toEntity(DbDoc dbDoc) {
        Object entity = null;
        try {
            String json = dbDoc.toString();
            entity = ObjectUtils.jsonMapper((ObjectUtils.Option[])new ObjectUtils.Option[0]).readValue(json, this.entityClass);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return (Entity)entity;
    }
}

