/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.dao;

import cool.scx.dao.ColumnMapping;
import cool.scx.sql.mapping.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class ColumnFilter {
    private final Set<String> fieldNames = new HashSet<String>();
    private final FilterMode filterMode;
    private final boolean excludeIfFieldValueIsNull;

    private ColumnFilter(FilterMode filterMode, boolean excludeIfFieldValueIsNull) {
        this.filterMode = filterMode;
        this.excludeIfFieldValueIsNull = excludeIfFieldValueIsNull;
    }

    public static ColumnFilter ofIncluded() {
        return ColumnFilter.ofIncluded(true);
    }

    public static ColumnFilter ofIncluded(boolean excludeIfFieldValueIsNull) {
        return new ColumnFilter(FilterMode.INCLUDED, excludeIfFieldValueIsNull);
    }

    public static ColumnFilter ofIncluded(String ... fieldNames) {
        return ColumnFilter.ofIncluded().addIncluded(fieldNames);
    }

    public static ColumnFilter ofIncluded(boolean excludeIfFieldValueIsNull, String ... fieldNames) {
        return ColumnFilter.ofIncluded(excludeIfFieldValueIsNull).addIncluded(fieldNames);
    }

    public static ColumnFilter ofExcluded() {
        return ColumnFilter.ofExcluded(true);
    }

    public static ColumnFilter ofExcluded(boolean excludeIfFieldValueIsNull) {
        return new ColumnFilter(FilterMode.EXCLUDED, excludeIfFieldValueIsNull);
    }

    public static ColumnFilter ofExcluded(String ... fieldNames) {
        return ColumnFilter.ofExcluded().addExcluded(fieldNames);
    }

    public static ColumnFilter ofExcluded(boolean excludeIfFieldValueIsNull, String ... fieldNames) {
        return ColumnFilter.ofExcluded(excludeIfFieldValueIsNull).addExcluded(fieldNames);
    }

    private ColumnFilter _addFieldNames(String ... fieldNames) {
        this.fieldNames.addAll(Arrays.asList(fieldNames));
        return this;
    }

    private ColumnFilter _removeFieldNames(String ... fieldNames) {
        for (String fieldName : fieldNames) {
            this.fieldNames.remove(fieldName);
        }
        return this;
    }

    public ColumnFilter addIncluded(String ... fieldNames) {
        return switch (this.filterMode) {
            default -> throw new IncompatibleClassChangeError();
            case FilterMode.INCLUDED -> this._addFieldNames(fieldNames);
            case FilterMode.EXCLUDED -> this._removeFieldNames(fieldNames);
        };
    }

    public ColumnFilter addExcluded(String ... fieldNames) {
        return switch (this.filterMode) {
            default -> throw new IncompatibleClassChangeError();
            case FilterMode.EXCLUDED -> this._addFieldNames(fieldNames);
            case FilterMode.INCLUDED -> this._removeFieldNames(fieldNames);
        };
    }

    public ColumnFilter removeIncluded(String ... fieldNames) {
        return this.addExcluded(fieldNames);
    }

    public ColumnFilter removeExcluded(String ... fieldNames) {
        return this.addIncluded(fieldNames);
    }

    public ColumnFilter clear() {
        this.fieldNames.clear();
        return this;
    }

    public ColumnMapping[] filter(Table<? extends ColumnMapping> tableInfo) {
        ColumnMapping[] columnMappingArray;
        if (this.fieldNames.size() == 0) {
            switch (this.filterMode) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case INCLUDED: {
                    columnMappingArray = new ColumnMapping[]{};
                    break;
                }
                case EXCLUDED: {
                    columnMappingArray = (ColumnMapping[])tableInfo.columns();
                    break;
                }
            }
        } else {
            switch (this.filterMode) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case INCLUDED: {
                    ArrayList<ColumnMapping> list = new ArrayList<ColumnMapping>();
                    for (String fieldName : this.fieldNames) {
                        list.add((ColumnMapping)tableInfo.getColumn(fieldName));
                    }
                    columnMappingArray = (ColumnMapping[])list.toArray(ColumnMapping[]::new);
                    break;
                }
                case EXCLUDED: {
                    ArrayList<ColumnMapping> objects = new ArrayList<ColumnMapping>(Arrays.asList((ColumnMapping[])tableInfo.columns()));
                    for (String fieldName : this.fieldNames) {
                        objects.remove(tableInfo.getColumn(fieldName));
                    }
                    columnMappingArray = (ColumnMapping[])objects.toArray(ColumnMapping[]::new);
                    break;
                }
            }
        }
        return columnMappingArray;
    }

    public FilterMode filterMode() {
        return this.filterMode;
    }

    public ColumnMapping[] filter(Object entity, Table<? extends ColumnMapping> tableInfo) {
        return this.excludeIfFieldValueIsNull ? this.excludeIfFieldValueIsNull(entity, this.filter(tableInfo)) : this.filter(tableInfo);
    }

    private ColumnMapping[] excludeIfFieldValueIsNull(Object entity, ColumnMapping ... scxDaoColumnInfos) {
        return (ColumnMapping[])Arrays.stream(scxDaoColumnInfos).filter((? super T field) -> field.javaFieldValue(entity) != null).toArray(ColumnMapping[]::new);
    }

    public static enum FilterMode {
        INCLUDED,
        EXCLUDED;


        public static FilterMode of(String filterModeStr) {
            return FilterMode.valueOf(filterModeStr.trim().toUpperCase());
        }
    }
}

