/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.dao.dialect;

import cool.scx.dao.ColumnMapping;
import cool.scx.sql.mapping.Column;
import cool.scx.sql.mapping.Table;
import cool.scx.util.StringUtils;
import java.sql.Driver;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;

public interface Dialect {
    public boolean canHandle(DataSource var1);

    public boolean canHandle(Driver var1);

    public String getFinalSQL(Statement var1);

    public String getLimitSQL(String var1, Integer var2, Integer var3);

    default public String getCreateTableDDL(Table<?> tableInfo) {
        StringBuilder s = new StringBuilder();
        s.append("CREATE TABLE ");
        if (StringUtils.notEmpty((String)tableInfo.schema())) {
            s.append(tableInfo.schema()).append(".");
        }
        s.append(tableInfo.name()).append("\n");
        s.append("(\n");
        String createDefinitionStr = this.getCreateDefinition(tableInfo).stream().map(c -> "    " + c).collect(Collectors.joining(",\n"));
        s.append(createDefinitionStr);
        s.append("\n);");
        return s.toString();
    }

    default public List<String> getCreateDefinition(Table<?> table) {
        ArrayList<String> createDefinitions = new ArrayList<String>();
        createDefinitions.addAll(this.getColumnDefinitions(table.columns()));
        createDefinitions.addAll(this.getTableConstraint(table));
        return createDefinitions;
    }

    default public List<String> getColumnDefinitions(Column[] columns) {
        ArrayList<String> list = new ArrayList<String>();
        for (Column column : columns) {
            list.add(this.getColumnDefinition(column));
        }
        return list;
    }

    default public List<String> getTableConstraint(Table<?> table) {
        return new ArrayList<String>();
    }

    default public String getColumnDefinition(Column column) {
        StringBuilder s = new StringBuilder();
        s.append(column.name()).append(" ");
        String dataTypeDefinition = this.getDataTypeDefinition(column);
        if (dataTypeDefinition != null) {
            s.append(dataTypeDefinition).append(" ");
        }
        String columnConstraintStr = String.join((CharSequence)" ", this.getColumnConstraint(column));
        s.append(columnConstraintStr);
        return s.toString();
    }

    default public String getDataTypeDefinition(Column column) {
        if (column.typeName() != null) {
            if (column.columnSize() != null) {
                return column.typeName() + "(" + column.columnSize() + ")";
            }
            return column.typeName();
        }
        if (column instanceof ColumnMapping) {
            ColumnMapping m = (ColumnMapping)column;
            return this.getDataTypeDefinitionByClass(m.javaField().getType());
        }
        return this.defaultDateType();
    }

    public List<String> getColumnConstraint(Column var1);

    public String getDataTypeDefinitionByClass(Class<?> var1);

    default public String defaultDateType() {
        return null;
    }

    default public String getAlertTableDDL(Column[] needAdds, Table<?> tableInfo) {
        StringBuilder s = new StringBuilder();
        s.append("ALTER TABLE ");
        if (StringUtils.notEmpty((String)tableInfo.schema())) {
            s.append(tableInfo.schema()).append(".");
        }
        s.append(tableInfo.name()).append("`\n");
        String columnDefinitionStr = this.getColumnDefinitions(needAdds).stream().map(c -> "    ADD COLUMN" + c).collect(Collectors.joining(",\n"));
        s.append(columnDefinitionStr);
        s.append("\n;");
        return s.toString();
    }
}

