/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.dao.impl.xdevapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import cool.scx.dao.impl.WhereParamsAndWhereClause;
import cool.scx.dao.query.WhereOption;
import cool.scx.dao.query.WhereType;
import cool.scx.dao.query.exception.ValidParamListIsEmptyException;
import cool.scx.util.ObjectUtils;
import cool.scx.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

interface WhereTypeHandler {
    public static final WhereTypeHandler IS_NULL_HANDLER;
    public static final WhereTypeHandler IS_NOT_NULL_HANDLER;
    public static final WhereTypeHandler EQUAL_HANDLER;
    public static final WhereTypeHandler NOT_EQUAL_HANDLER;
    public static final WhereTypeHandler LESS_THAN_HANDLER;
    public static final WhereTypeHandler LESS_THAN_OR_EQUAL_HANDLER;
    public static final WhereTypeHandler GREATER_THAN_HANDLER;
    public static final WhereTypeHandler GREATER_THAN_OR_EQUAL_HANDLER;
    public static final WhereTypeHandler LIKE_REGEX_HANDLER;
    public static final WhereTypeHandler NOT_LIKE_REGEX_HANDLER;
    public static final WhereTypeHandler LIKE_HANDLER;
    public static final WhereTypeHandler NOT_LIKE_HANDLER;
    public static final WhereTypeHandler IN_HANDLER;
    public static final WhereTypeHandler NOT_IN_HANDLER;
    public static final WhereTypeHandler BETWEEN_HANDLER;
    public static final WhereTypeHandler NOT_BETWEEN_HANDLER;
    public static final WhereTypeHandler JSON_CONTAINS_HANDLER;

    public static WhereTypeHandler findWhereTypeHandler(WhereType whereType) {
        return switch (whereType) {
            default -> throw new IncompatibleClassChangeError();
            case WhereType.IS_NULL -> IS_NULL_HANDLER;
            case WhereType.IS_NOT_NULL -> IS_NOT_NULL_HANDLER;
            case WhereType.EQUAL -> EQUAL_HANDLER;
            case WhereType.NOT_EQUAL -> NOT_EQUAL_HANDLER;
            case WhereType.LESS_THAN -> LESS_THAN_HANDLER;
            case WhereType.LESS_THAN_OR_EQUAL -> LESS_THAN_OR_EQUAL_HANDLER;
            case WhereType.GREATER_THAN -> GREATER_THAN_HANDLER;
            case WhereType.GREATER_THAN_OR_EQUAL -> GREATER_THAN_OR_EQUAL_HANDLER;
            case WhereType.LIKE -> LIKE_HANDLER;
            case WhereType.NOT_LIKE -> NOT_LIKE_HANDLER;
            case WhereType.LIKE_REGEX -> LIKE_REGEX_HANDLER;
            case WhereType.NOT_LIKE_REGEX -> NOT_LIKE_REGEX_HANDLER;
            case WhereType.IN -> IN_HANDLER;
            case WhereType.NOT_IN -> NOT_IN_HANDLER;
            case WhereType.BETWEEN -> BETWEEN_HANDLER;
            case WhereType.NOT_BETWEEN -> NOT_BETWEEN_HANDLER;
            case WhereType.JSON_CONTAINS -> JSON_CONTAINS_HANDLER;
        };
    }

    public WhereParamsAndWhereClause getWhereParamsAndWhereClause(String var1, WhereType var2, Object var3, Object var4, WhereOption.Info var5);

    static {
        IS_NOT_NULL_HANDLER = IS_NULL_HANDLER = (name, whereType, value1, value2, info) -> {
            Object[] whereParams = new Object[]{};
            String whereClause = name + " " + whereType.keyWord();
            return new WhereParamsAndWhereClause(whereParams, whereClause);
        };
        NOT_EQUAL_HANDLER = EQUAL_HANDLER = (name, whereType, value1, value2, info) -> {
            Object[] whereParams = new Object[]{value1};
            String v1 = "?";
            String whereClause = name + " " + whereType.keyWord() + " " + v1;
            return new WhereParamsAndWhereClause(whereParams, whereClause);
        };
        LESS_THAN_HANDLER = EQUAL_HANDLER;
        LESS_THAN_OR_EQUAL_HANDLER = EQUAL_HANDLER;
        GREATER_THAN_HANDLER = EQUAL_HANDLER;
        GREATER_THAN_OR_EQUAL_HANDLER = EQUAL_HANDLER;
        LIKE_REGEX_HANDLER = EQUAL_HANDLER;
        NOT_LIKE_REGEX_HANDLER = EQUAL_HANDLER;
        NOT_LIKE_HANDLER = LIKE_HANDLER = (name, whereType, value1, value2, info) -> {
            String v1 = "?";
            Object[] whereParams = new Object[]{value1};
            String whereClause = name + " " + whereType.keyWord() + " CONCAT('%'," + v1 + ",'%')";
            return new WhereParamsAndWhereClause(whereParams, whereClause);
        };
        NOT_IN_HANDLER = IN_HANDLER = (name, whereType, value1, value2, info) -> {
            Object[] whereParams = Arrays.stream(ObjectUtils.toObjectArray((Object)value1)).filter(Objects::nonNull).distinct().toArray();
            if (whereParams.length == 0) {
                throw new ValidParamListIsEmptyException(whereType);
            }
            String v1 = "(" + StringUtils.repeat((String)"?", (String)", ", (int)whereParams.length) + ")";
            String whereClause = name + " " + whereType.keyWord() + " " + v1;
            return new WhereParamsAndWhereClause(whereParams, whereClause);
        };
        NOT_BETWEEN_HANDLER = BETWEEN_HANDLER = (name, whereType, value1, value2, info) -> {
            ArrayList<Object> whereParams = new ArrayList<Object>();
            String v1 = "?";
            whereParams.add(value1);
            String v2 = "?";
            whereParams.add(value2);
            String whereClause = name + " " + whereType.keyWord() + " " + v1 + " AND " + v2;
            return new WhereParamsAndWhereClause(whereParams.toArray(), whereClause);
        };
        JSON_CONTAINS_HANDLER = (name, whereType, value1, value2, info) -> {
            Object[] whereParams;
            String v1 = "?";
            if (info.useOriginalValue()) {
                whereParams = new Object[]{value1};
            } else {
                try {
                    whereParams = new Object[]{ObjectUtils.toJson((Object)value1, (ObjectUtils.Option[])new ObjectUtils.Option[]{ObjectUtils.Option.IGNORE_JSON_IGNORE, ObjectUtils.Option.IGNORE_NULL_VALUE})};
                }
                catch (JsonProcessingException e) {
                    throw new IllegalArgumentException("\u4f7f\u7528 JSON_CONTAINS \u65f6, \u67e5\u8be2\u53c2\u6570\u4e0d\u5408\u6cd5(\u65e0\u6cd5\u6b63\u786e\u8f6c\u6362\u4e3a JSON) !!! \u5b57\u6bb5\u540d : " + name, e);
                }
            }
            String whereClause = whereType.keyWord() + "(" + name;
            whereClause = whereClause + ", " + v1 + ")";
            return new WhereParamsAndWhereClause(whereParams, whereClause);
        };
    }
}

