/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.dao.impl.xdevapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.mysql.cj.xdevapi.AddResult;
import com.mysql.cj.xdevapi.DbDoc;
import com.mysql.cj.xdevapi.DocResult;
import com.mysql.cj.xdevapi.FindStatement;
import com.mysql.cj.xdevapi.JsonParser;
import com.mysql.cj.xdevapi.ModifyStatement;
import com.mysql.cj.xdevapi.RemoveStatement;
import com.mysql.cj.xdevapi.Result;
import com.mysql.cj.xdevapi.Schema;
import com.mysql.cj.xdevapi.Session;
import cool.scx.dao.AnnotationConfigTable;
import cool.scx.dao.BaseDao;
import cool.scx.dao.ColumnFilter;
import cool.scx.dao.Query;
import cool.scx.dao.impl.xdevapi.MySQLXDaoWhereParser;
import cool.scx.dao.query.parser.WhereClauseAndWhereParams;
import cool.scx.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MySQLXDao<Entity>
implements BaseDao<Entity, String> {
    private final Session session;
    private final Schema schema;
    private final com.mysql.cj.xdevapi.Collection collection;
    private final Class<Entity> entityClass;
    private final MySQLXDaoWhereParser whereParser;

    public MySQLXDao(Class<Entity> entityClass, Session session, String tableName) {
        this.entityClass = entityClass;
        this.session = session;
        this.schema = session.getDefaultSchema();
        this.collection = this.schema.createCollection(tableName, true);
        this.whereParser = new MySQLXDaoWhereParser();
    }

    public MySQLXDao(Class<Entity> entityClass, Session session) {
        this(entityClass, session, AnnotationConfigTable.initTableName(entityClass));
    }

    @Override
    public String insert(Entity entity, ColumnFilter updateFilter) {
        DbDoc dbDoc = this.toDbDoc(entity, updateFilter);
        AddResult execute = (AddResult)this.collection.add(dbDoc).execute();
        List generatedIds = execute.getGeneratedIds();
        return (String)generatedIds.get(0);
    }

    @Override
    public List<String> insertBatch(Collection<Entity> entityList, ColumnFilter updateFilter) {
        DbDoc[] dbDocs = new DbDoc[entityList.size()];
        int index = 0;
        for (Entity entity : entityList) {
            dbDocs[index] = this.toDbDoc(entity, updateFilter);
            ++index;
        }
        AddResult execute = (AddResult)this.collection.add(dbDocs).execute();
        return execute.getGeneratedIds();
    }

    @Override
    public List<Entity> select(Query query, ColumnFilter selectFilter) {
        WhereClauseAndWhereParams whereClauseAndWhereParams = this.whereParser.parseWhere(query.where());
        String findStr = whereClauseAndWhereParams.whereClause();
        FindStatement findStatement = (FindStatement)this.collection.find(findStr).bind(whereClauseAndWhereParams.whereParams());
        if (query.limit().offset() != null) {
            findStatement.offset((long)query.limit().offset().intValue());
        }
        if (query.limit().rowCount() != null) {
            findStatement.limit((long)query.limit().rowCount().intValue());
        }
        DocResult docResult = (DocResult)findStatement.execute();
        List dbDocs = docResult.fetchAll();
        ArrayList<Entity> list = new ArrayList<Entity>();
        for (DbDoc dbDoc : dbDocs) {
            list.add(this.toEntity(dbDoc));
        }
        return list;
    }

    @Override
    public long update(Entity entity, Query query, ColumnFilter updateFilter) {
        WhereClauseAndWhereParams whereClauseAndWhereParams = this.whereParser.parseWhere(query.where());
        String findStr = whereClauseAndWhereParams.whereClause();
        DbDoc newDoc = this.toDbDoc(entity, updateFilter);
        Result result = (Result)((ModifyStatement)this.collection.modify(findStr).bind(whereClauseAndWhereParams.whereParams())).patch(newDoc).execute();
        return result.getAffectedItemsCount();
    }

    @Override
    public long delete(Query query) {
        WhereClauseAndWhereParams whereClauseAndWhereParams = this.whereParser.parseWhere(query.where());
        String findStr = whereClauseAndWhereParams.whereClause();
        Result result = (Result)((RemoveStatement)this.collection.remove(findStr).bind(whereClauseAndWhereParams.whereParams())).execute();
        return result.getAffectedItemsCount();
    }

    @Override
    public long count(Query query) {
        WhereClauseAndWhereParams whereClauseAndWhereParams = this.whereParser.parseWhere(query.where());
        String findStr = whereClauseAndWhereParams.whereClause();
        FindStatement findStatement = (FindStatement)this.collection.find(findStr).bind(whereClauseAndWhereParams.whereParams());
        return ((DocResult)findStatement.execute()).count();
    }

    @Override
    public Class<Entity> _entityClass() {
        return this.entityClass;
    }

    public DbDoc toDbDoc(Object entity, ColumnFilter updateFilter) {
        String json = null;
        try {
            json = ObjectUtils.toJson((Object)entity, (ObjectUtils.Option[])new ObjectUtils.Option[0]);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return JsonParser.parseDoc((String)json);
    }

    public Entity toEntity(DbDoc dbDoc) {
        Object entity = null;
        try {
            String json = dbDoc.toString();
            entity = ObjectUtils.jsonMapper((ObjectUtils.Option[])new ObjectUtils.Option[0]).readValue(json, this.entityClass);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return (Entity)entity;
    }
}

