/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.dao.query.parser;

import cool.scx.dao.query.AND;
import cool.scx.dao.query.Logic;
import cool.scx.dao.query.Where;
import cool.scx.dao.query.WhereBody;
import cool.scx.dao.query.parser.WhereClauseAndWhereParams;
import cool.scx.sql.sql.SQL;
import java.util.ArrayList;
import java.util.List;

public abstract class WhereParser {
    public final WhereClauseAndWhereParams parseAll(Object[] objs) {
        StringBuilder whereClause = new StringBuilder();
        ArrayList<Object> whereParams = new ArrayList<Object>();
        for (Object obj : objs) {
            WhereClauseAndWhereParams w = this.parse(obj);
            if (w == null) continue;
            whereClause.append(w.whereClause());
            whereParams.addAll(List.of(w.whereParams()));
        }
        return new WhereClauseAndWhereParams(whereClause.toString(), whereParams.toArray());
    }

    public final WhereClauseAndWhereParams parse(Object obj) {
        if (obj instanceof String) {
            String str = (String)obj;
            return this.parseString(str);
        }
        if (obj instanceof WhereBody) {
            WhereBody whereBody = (WhereBody)obj;
            return this.parseWhereBody(whereBody);
        }
        if (obj instanceof SQL) {
            SQL s = (SQL)obj;
            return this.parseSQL(s);
        }
        if (obj instanceof Logic) {
            Logic l = (Logic)obj;
            return this.parseLogic(l);
        }
        return null;
    }

    public final WhereClauseAndWhereParams parseString(String str) {
        return new WhereClauseAndWhereParams(str, new Object[0]);
    }

    public abstract WhereClauseAndWhereParams parseWhereBody(WhereBody var1);

    public final WhereClauseAndWhereParams parseSQL(SQL sql) {
        return new WhereClauseAndWhereParams("(" + sql.sql() + ")", sql.params());
    }

    public final WhereClauseAndWhereParams parseLogic(Logic l) {
        ArrayList<String> clauses = new ArrayList<String>();
        ArrayList<Object> whereParams = new ArrayList<Object>();
        for (Object c : l.clauses()) {
            WhereClauseAndWhereParams w = this.parse(c);
            if (w == null) continue;
            clauses.add(w.whereClause());
            whereParams.addAll(List.of(w.whereParams()));
        }
        Object clause = String.join((CharSequence)(" " + l.keyWord() + " "), clauses);
        if (clauses.size() > 1) {
            clause = "(" + (String)clause + ")";
        }
        return new WhereClauseAndWhereParams((String)clause, whereParams.toArray());
    }

    public final WhereClauseAndWhereParams parseWhere(Where where) {
        WhereClauseAndWhereParams w1 = this.parse(new AND(where.whereBodyList().toArray()));
        WhereClauseAndWhereParams w2 = this.parseAll(where.whereSQL());
        String whereClause = w1.whereClause() + w2.whereClause();
        ArrayList<Object> whereParams = new ArrayList<Object>();
        whereParams.addAll(List.of(w1.whereParams()));
        whereParams.addAll(List.of(w2.whereParams()));
        return new WhereClauseAndWhereParams(whereClause, whereParams.toArray());
    }
}

