package cool.scx.dao.spy.wrapper;


import cool.scx.dao.spy.SpyEventListener;
import cool.scx.util.ArrayUtils;

import java.sql.*;


public class StatementWrapper extends AbstractWrapper implements Statement {

    protected final SpyEventListener eventListener;

    private final Statement statement;

    protected StatementWrapper(Statement delegate, SpyEventListener eventListener) {
        super(delegate);
        this.statement = delegate;
        this.eventListener = eventListener;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        try {
            return statement.getResultSet();
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            eventListener.onAfterGetResultSet(statement, System.nanoTime() - start, e);
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {

        SQLException e = null;
        long start = System.nanoTime();
        try {
            eventListener.onBeforeExecuteQuery(statement, sql);
            return statement.executeQuery(sql);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            eventListener.onAfterExecuteQuery(statement, System.nanoTime() - start, sql, e);
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        int[] updateCounts = null;
        try {
            eventListener.onBeforeExecuteBatch(statement);
            updateCounts = statement.executeBatch();
            return updateCounts;
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            eventListener.onAfterExecuteBatch(statement, System.nanoTime() - start, ArrayUtils.toLongArray(updateCounts), e);
        }
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        long[] updateCounts = null;
        try {
            eventListener.onBeforeExecuteBatch(statement);
            updateCounts = statement.executeLargeBatch();
            return updateCounts;
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            eventListener.onAfterExecuteBatch(statement, System.nanoTime() - start, updateCounts, e);
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        try {
            eventListener.onBeforeExecute(statement, sql);
            return statement.execute(sql);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            eventListener.onAfterExecute(statement, System.nanoTime() - start, sql, e);
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        try {
            eventListener.onBeforeExecute(statement, sql);
            return statement.execute(sql, autoGeneratedKeys);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            eventListener.onAfterExecute(statement, System.nanoTime() - start, sql, e);
        }
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        try {
            eventListener.onBeforeExecute(statement, sql);
            return statement.execute(sql, columnIndexes);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            eventListener.onAfterExecute(statement, System.nanoTime() - start, sql, e);
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        try {
            eventListener.onBeforeExecute(statement, sql);
            return statement.execute(sql, columnNames);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            eventListener.onAfterExecute(statement, System.nanoTime() - start, sql, e);
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        int rowCount = 0;
        try {
            eventListener.onBeforeExecuteUpdate(statement, sql);
            rowCount = statement.executeUpdate(sql);
            return rowCount;
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            eventListener.onAfterExecuteUpdate(statement, System.nanoTime() - start, sql, rowCount, e);
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        int rowCount = 0;
        try {
            eventListener.onBeforeExecuteUpdate(statement, sql);
            rowCount = statement.executeUpdate(sql, autoGeneratedKeys);
            return rowCount;
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            eventListener.onAfterExecuteUpdate(statement, System.nanoTime() - start, sql, rowCount, e);
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        int rowCount = 0;
        try {
            eventListener.onBeforeExecuteUpdate(statement, sql);
            rowCount = statement.executeUpdate(sql, columnIndexes);
            return rowCount;
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            eventListener.onAfterExecuteUpdate(statement, System.nanoTime() - start, sql, rowCount, e);
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        int rowCount = 0;
        try {
            eventListener.onBeforeExecuteUpdate(statement, sql);
            rowCount = statement.executeUpdate(sql, columnNames);
            return rowCount;
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            eventListener.onAfterExecuteUpdate(statement, System.nanoTime() - start, sql, rowCount, e);
        }
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        long rowCount = 0;
        try {
            eventListener.onBeforeExecuteUpdate(statement, sql);
            rowCount = statement.executeLargeUpdate(sql);
            return rowCount;
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            eventListener.onAfterExecuteUpdate(statement, System.nanoTime() - start, sql, rowCount, e);
        }
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        long rowCount = 0;
        try {
            eventListener.onBeforeExecuteUpdate(statement, sql);
            rowCount = statement.executeLargeUpdate(sql, autoGeneratedKeys);
            return rowCount;
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            eventListener.onAfterExecuteUpdate(statement, System.nanoTime() - start, sql, rowCount, e);
        }
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        long rowCount = 0;
        try {
            eventListener.onBeforeExecuteUpdate(statement, sql);
            rowCount = statement.executeLargeUpdate(sql, columnIndexes);
            return rowCount;
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            eventListener.onAfterExecuteUpdate(statement, System.nanoTime() - start, sql, rowCount, e);
        }
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        long rowCount = 0;
        try {
            eventListener.onBeforeExecuteUpdate(statement, sql);
            rowCount = statement.executeLargeUpdate(sql, columnNames);
            return rowCount;
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            eventListener.onAfterExecuteUpdate(statement, System.nanoTime() - start, sql, rowCount, e);
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        try {
            eventListener.onBeforeAddBatch(statement, sql);
            statement.addBatch(sql);
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            eventListener.onAfterAddBatch(statement, System.nanoTime() - start, sql, e);
        }
    }

    @Override
    public void close() throws SQLException {
        SQLException e = null;
        try {
            statement.close();
        } catch (SQLException sqle) {
            e = sqle;
            throw e;
        } finally {
            eventListener.onAfterStatementClose(statement, e);
        }
    }

    // ***********
    // 以下为委托方法
    // ***********

    @Override
    public int getMaxFieldSize() throws SQLException {
        return statement.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        statement.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return statement.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        statement.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        statement.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return statement.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        statement.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        statement.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return statement.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        statement.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        statement.setCursorName(name);
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return statement.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return statement.getMoreResults();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return statement.getFetchDirection();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        statement.setFetchDirection(direction);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return statement.getFetchSize();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        statement.setFetchSize(rows);
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return statement.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return statement.getResultSetType();
    }


    @Override
    public void clearBatch() throws SQLException {
        statement.clearBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return statement.getConnection();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return statement.getMoreResults(current);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return statement.getGeneratedKeys();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return statement.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return statement.isClosed();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return statement.isPoolable();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        statement.setPoolable(poolable);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        statement.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return statement.isCloseOnCompletion();
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        return statement.getLargeUpdateCount();
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        return statement.getLargeMaxRows();
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        statement.setLargeMaxRows(max);
    }

    @Override
    public String enquoteLiteral(String val) throws SQLException {
        return statement.enquoteLiteral(val);
    }

    @Override
    public String enquoteIdentifier(String identifier, boolean alwaysQuote) throws SQLException {
        return statement.enquoteIdentifier(identifier, alwaysQuote);
    }

    @Override
    public boolean isSimpleIdentifier(String identifier) throws SQLException {
        return statement.isSimpleIdentifier(identifier);
    }

    @Override
    public String enquoteNCharLiteral(String val) throws SQLException {
        return statement.enquoteNCharLiteral(val);
    }

}
