/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.dao.jdbc;

import cool.scx.sql.mapping.Table;
import cool.scx.util.StringUtils;

final class ColumnNameParser {
    ColumnNameParser() {
    }

    public static String parseColumnName(Table<?> tableInfo, String name, boolean useJsonExtract, boolean useOriginalName) {
        if (useJsonExtract) {
            ColumnNameAndFieldPath c = ColumnNameParser.splitIntoColumnNameAndFieldPath(name);
            if (StringUtils.notBlank((String)c.columnName()) && StringUtils.notBlank((String)c.fieldPath())) {
                String jsonQueryColumnName = useOriginalName ? c.columnName() : tableInfo.getColumn(c.columnName()).name();
                return jsonQueryColumnName + " -> '$" + c.fieldPath() + "'";
            }
            throw new IllegalArgumentException("\u4f7f\u7528 USE_JSON_EXTRACT \u65f6, \u67e5\u8be2\u540d\u79f0\u4e0d\u5408\u6cd5 !!! \u5b57\u6bb5\u540d : " + name);
        }
        return useOriginalName ? name : tableInfo.getColumn(name).name();
    }

    public static ColumnNameAndFieldPath splitIntoColumnNameAndFieldPath(String name) {
        char[] charArray = name.toCharArray();
        int index = charArray.length;
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (c != '.' && c != '[') continue;
            index = i;
            break;
        }
        String columnName = name.substring(0, index);
        String fieldPath = name.substring(index);
        return new ColumnNameAndFieldPath(columnName, fieldPath);
    }

    public record ColumnNameAndFieldPath(String columnName, String fieldPath) {
    }
}

