/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.dao.jdbc;

import cool.scx.dao.AnnotationConfigColumn;
import cool.scx.dao.AnnotationConfigTable;
import cool.scx.dao.BaseDao;
import cool.scx.dao.ColumnFilter;
import cool.scx.dao.ColumnMapping;
import cool.scx.dao.Query;
import cool.scx.dao.dialect.Dialect;
import cool.scx.dao.dialect.DialectSelector;
import cool.scx.dao.jdbc.JDBCDaoGroupByParser;
import cool.scx.dao.jdbc.JDBCDaoOrderByParser;
import cool.scx.dao.jdbc.JDBCDaoWhereParser;
import cool.scx.dao.jdbc.SQLBuilder;
import cool.scx.dao.query.parser.WhereClauseAndWhereParams;
import cool.scx.sql.SQLRunner;
import cool.scx.sql.mapping.Column;
import cool.scx.sql.mapping.Table;
import cool.scx.sql.result_handler.ResultHandler;
import cool.scx.sql.sql.SQL;
import cool.scx.util.ArrayUtils;
import cool.scx.util.RandomUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;

public class JDBCDao<Entity>
implements BaseDao<Entity, Long> {
    protected final AnnotationConfigTable tableInfo;
    protected final Class<Entity> entityClass;
    protected final SQLRunner sqlRunner;
    protected final ResultHandler<List<Entity>> entityBeanListHandler;
    protected final ResultHandler<Long> countResultHandler;
    protected final Dialect dialect;
    protected final JDBCDaoWhereParser whereParser;
    protected final JDBCDaoGroupByParser groupByParser;
    protected final JDBCDaoOrderByParser orderByParser;

    public JDBCDao(Class<Entity> entityClass, DataSource dataSource) {
        this.entityClass = entityClass;
        this.dialect = DialectSelector.findDialect(dataSource);
        this.tableInfo = new AnnotationConfigTable(entityClass);
        this.sqlRunner = new SQLRunner(dataSource);
        this.entityBeanListHandler = ResultHandler.ofBeanList(this.entityClass, field -> {
            AnnotationConfigColumn columnInfo = this.tableInfo.getColumn(field.getName());
            return columnInfo == null ? null : columnInfo.name();
        });
        this.countResultHandler = ResultHandler.ofSingleValue((String)"count", Long.class);
        this.whereParser = new JDBCDaoWhereParser(this.tableInfo);
        this.groupByParser = new JDBCDaoGroupByParser(this.tableInfo);
        this.orderByParser = new JDBCDaoOrderByParser(this.tableInfo);
    }

    @Override
    public final Long insert(Entity entity, ColumnFilter updateFilter) {
        return this.sqlRunner.update(this._buildInsertSQL(entity, updateFilter)).firstGeneratedKey();
    }

    private SQL _buildInsertSQL(Entity entity, ColumnFilter updateFilter) {
        ColumnMapping[] insertColumnInfos = updateFilter.filter(entity, this.tableInfo);
        String[] insertColumns = (String[])Arrays.stream(insertColumnInfos).map(Column::name).toArray(String[]::new);
        String[] insertValues = (String[])Arrays.stream(insertColumnInfos).map(columnInfo -> "?").toArray(String[]::new);
        String sql = SQLBuilder.Insert(this.tableInfo.name(), insertColumns).Values(insertValues).GetSQL(this.dialect);
        Object[] objectArray = Arrays.stream(insertColumnInfos).map(c -> c.javaFieldValue(entity)).toArray();
        return SQL.ofPlaceholder((String)sql, (Object[])objectArray);
    }

    @Override
    public final List<Long> insertBatch(Collection<Entity> entityList, ColumnFilter updateFilter) {
        return this.sqlRunner.updateBatch(this.buildInsertBatchSQL(entityList, updateFilter)).generatedKeys();
    }

    private SQL buildInsertBatchSQL(Collection<Entity> entityList, ColumnFilter updateFilter) {
        ColumnMapping[] insertColumnInfos = updateFilter.filter(this.tableInfo);
        ArrayList<Object[]> objectArrayList = new ArrayList<Object[]>();
        for (Entity entity : entityList) {
            Object[] o = new Object[insertColumnInfos.length];
            for (int i = 0; i < insertColumnInfos.length; ++i) {
                o[i] = insertColumnInfos[i].javaFieldValue(entity);
            }
            objectArrayList.add(o);
        }
        String[] insertColumns = (String[])Arrays.stream(insertColumnInfos).map(Column::name).toArray(String[]::new);
        String[] insertValues = (String[])Arrays.stream(insertColumnInfos).map(c -> "?").toArray(String[]::new);
        String sql = SQLBuilder.Insert(this.tableInfo.name(), insertColumns).Values(insertValues).GetSQL(this.dialect);
        return SQL.ofPlaceholder((String)sql, objectArrayList);
    }

    @Override
    public final List<Entity> select(Query query, ColumnFilter selectFilter) {
        return (List)this.sqlRunner.query(this.buildSelectSQL(query, selectFilter), this.entityBeanListHandler);
    }

    public final SQL buildSelectSQL(Query query, ColumnFilter selectFilter) {
        ColumnMapping[] selectColumnInfos = selectFilter.filter(this.tableInfo);
        String[] selectColumns = (String[])Arrays.stream(selectColumnInfos).map(Column::name).toArray(String[]::new);
        WhereClauseAndWhereParams whereClauseAndWhereParams = this.whereParser.parseWhere(query.where());
        String[] groupByColumns = this.groupByParser.parseGroupBy(query.groupBy());
        String[] orderByClauses = this.orderByParser.parseOrderBy(query.orderBy());
        String sql = SQLBuilder.Select(selectColumns).From(this.tableInfo.name()).Where(whereClauseAndWhereParams.whereClause()).GroupBy(groupByColumns).OrderBy(orderByClauses).Limit(query.limit().offset(), query.limit().rowCount()).GetSQL(this.dialect);
        return SQL.ofPlaceholder((String)sql, (Object[])whereClauseAndWhereParams.whereParams());
    }

    public final SQL buildSelectSQLWithAlias(Query query, ColumnFilter selectFilter) {
        if (query.limit().rowCount() == null) {
            return this.buildSelectSQL(query, selectFilter);
        }
        ColumnMapping[] selectColumnInfos = selectFilter.filter(this.tableInfo);
        String[] selectColumns = (String[])Arrays.stream(selectColumnInfos).map(Column::name).toArray(String[]::new);
        WhereClauseAndWhereParams whereClauseAndWhereParams = this.whereParser.parseWhere(query.where());
        String[] groupByColumns = this.groupByParser.parseGroupBy(query.groupBy());
        String[] orderByClauses = this.orderByParser.parseOrderBy(query.orderBy());
        String sql0 = SQLBuilder.Select(selectColumns).From(this.tableInfo.name()).Where(whereClauseAndWhereParams.whereClause()).GroupBy(groupByColumns).OrderBy(orderByClauses).Limit(query.limit().offset(), query.limit().rowCount()).GetSQL(this.dialect);
        String sql = SQLBuilder.Select("*").From("(" + sql0 + ")").GetSQL(this.dialect);
        return SQL.ofPlaceholder((String)(sql + " AS " + this.tableInfo.name() + "_" + RandomUtils.randomString((int)6)), (Object[])whereClauseAndWhereParams.whereParams());
    }

    @Override
    public final long count(Query query) {
        return (Long)this.sqlRunner.query(this.buildCountSQL(query), this.countResultHandler);
    }

    private SQL buildCountSQL(Query query) {
        WhereClauseAndWhereParams whereClauseAndWhereParams = this.whereParser.parseWhere(query.where());
        String[] groupByColumns = this.groupByParser.parseGroupBy(query.groupBy());
        String sql = SQLBuilder.Select("COUNT(*) AS count").From(this.tableInfo.name()).Where(whereClauseAndWhereParams.whereClause()).GroupBy(groupByColumns).GetSQL(this.dialect);
        return SQL.ofPlaceholder((String)sql, (Object[])whereClauseAndWhereParams.whereParams());
    }

    @Override
    public final long update(Entity entity, Query query, ColumnFilter updateFilter) {
        return this.sqlRunner.update(this.buildUpdateSQL(entity, query, updateFilter)).affectedItemsCount();
    }

    private SQL buildUpdateSQL(Entity entity, Query query, ColumnFilter updateFilter) {
        if (query.where().isEmpty()) {
            throw new IllegalArgumentException("\u66f4\u65b0\u6570\u636e\u65f6 \u5fc5\u987b\u6307\u5b9a \u5220\u9664\u6761\u4ef6 \u6216 \u81ea\u5b9a\u4e49\u7684 where \u8bed\u53e5 !!!");
        }
        ColumnMapping[] updateSetColumnInfos = updateFilter.filter(entity, this.tableInfo);
        String[] updateSetColumns = (String[])Arrays.stream(updateSetColumnInfos).map(c -> c.name() + " = ?").toArray(String[]::new);
        WhereClauseAndWhereParams whereClauseAndWhereParams = this.whereParser.parseWhere(query.where());
        String sql = SQLBuilder.Update(this.tableInfo.name()).Set(updateSetColumns).Where(whereClauseAndWhereParams.whereClause()).GetSQL(this.dialect);
        Object[] entityParams = Arrays.stream(updateSetColumnInfos).map(c -> c.javaFieldValue(entity)).toArray();
        return SQL.ofPlaceholder((String)sql, (Object[])ArrayUtils.concat((Object[])entityParams, (Object[])whereClauseAndWhereParams.whereParams()));
    }

    @Override
    public final long delete(Query query) {
        return this.sqlRunner.update(this.buildDeleteSQL(query)).affectedItemsCount();
    }

    private SQL buildDeleteSQL(Query query) {
        if (query.where().isEmpty()) {
            throw new IllegalArgumentException("\u5220\u9664\u6570\u636e\u65f6 \u5fc5\u987b\u6307\u5b9a \u5220\u9664\u6761\u4ef6 \u6216 \u81ea\u5b9a\u4e49\u7684 where \u8bed\u53e5 !!!");
        }
        WhereClauseAndWhereParams whereClauseAndWhereParams = this.whereParser.parseWhere(query.where());
        String sql = SQLBuilder.Delete(this.tableInfo.name()).Where(whereClauseAndWhereParams.whereClause()).GetSQL(this.dialect);
        return SQL.ofPlaceholder((String)sql, (Object[])whereClauseAndWhereParams.whereParams());
    }

    public final void _truncate() {
        this.sqlRunner.execute(SQL.ofNormal((String)("truncate " + this.tableInfo.name())));
    }

    public final Table<? extends ColumnMapping> _tableInfo() {
        return this.tableInfo;
    }

    @Override
    public final Class<Entity> _entityClass() {
        return this.entityClass;
    }

    public final SQLRunner _sqlRunner() {
        return this.sqlRunner;
    }
}

