/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.dao.spy.event;

import cool.scx.dao.dialect.Dialect;
import cool.scx.dao.spy.event.SimpleJdbcEventListener;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingEventListener
extends SimpleJdbcEventListener {
    private static final Logger logger = LoggerFactory.getLogger((String)"ScxSpy");
    private final Dialect dialect;

    public LoggingEventListener(Dialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public void onBeforeAnyExecute(Statement statement) {
        if (logger.isDebugEnabled()) {
            logger.debug(this.dialect.getFinalSQL(statement));
        }
    }

    @Override
    public void onAfterAnyExecute(Statement statement, long timeElapsedNanos, SQLException e) {
        if (logger.isDebugEnabled()) {
            // empty if block
        }
    }

    @Override
    public void onBeforeAnyAddBatch(Statement Statement2) {
        super.onBeforeAnyAddBatch(Statement2);
    }

    @Override
    public void onAfterAnyAddBatch(Statement Statement2, long timeElapsedNanos, SQLException e) {
        super.onAfterAnyAddBatch(Statement2, timeElapsedNanos, e);
    }
}

