/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.spy.wrapper;

import cool.scx.data.jdbc.dialect.DialectSelector;
import cool.scx.data.jdbc.spy.SpyEventListener;
import cool.scx.data.jdbc.spy.event.LoggingEventListener;
import cool.scx.data.jdbc.spy.wrapper.AbstractWrapper;
import cool.scx.data.jdbc.spy.wrapper.ConnectionWrapper;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ConnectionBuilder;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.ShardingKeyBuilder;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class DataSourceWrapper
extends AbstractWrapper
implements DataSource {
    private final DataSource dataSource;
    private final SpyEventListener eventListener;

    public DataSourceWrapper(DataSource dataSource, SpyEventListener eventListener) {
        super(dataSource);
        this.dataSource = dataSource;
        this.eventListener = eventListener;
    }

    public DataSourceWrapper(DataSource dataSource) {
        this(dataSource, new LoggingEventListener(DialectSelector.findDialect((DataSource)dataSource)));
    }

    @Override
    public Connection getConnection() throws SQLException {
        return new ConnectionWrapper(this.dataSource.getConnection(), this.eventListener);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return new ConnectionWrapper(this.dataSource.getConnection(username, password), this.eventListener);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.dataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.dataSource.setLogWriter(out);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.dataSource.getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.dataSource.setLoginTimeout(seconds);
    }

    @Override
    public ConnectionBuilder createConnectionBuilder() throws SQLException {
        return this.dataSource.createConnectionBuilder();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.dataSource.getParentLogger();
    }

    @Override
    public ShardingKeyBuilder createShardingKeyBuilder() throws SQLException {
        return this.dataSource.createShardingKeyBuilder();
    }
}

