/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc;

import cool.scx.data.Aggregator;
import cool.scx.data.aggregation.Aggregation;
import cool.scx.data.jdbc.JDBCRepository;
import cool.scx.data.query.Query;
import cool.scx.jdbc.result_handler.ResultHandler;
import cool.scx.jdbc.result_handler.map_builder.MapBuilder;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public class JDBCAggregator
implements Aggregator {
    private final JDBCRepository<?> repository;
    private final Query beforeAggregateQuery;
    private final Aggregation aggregationDefinition;
    private final Query afterAggregateQuery;

    public JDBCAggregator(JDBCRepository<?> repository, Query beforeAggregateQuery, Aggregation aggregationDefinition, Query afterAggregateQuery) {
        this.repository = repository;
        this.beforeAggregateQuery = beforeAggregateQuery;
        this.aggregationDefinition = aggregationDefinition;
        this.afterAggregateQuery = afterAggregateQuery;
    }

    public <T> List<T> list(Class<T> resultType) {
        return (List)this.repository.sqlRunner.query(this.repository.buildAggregateSQL(this.beforeAggregateQuery, this.aggregationDefinition, this.afterAggregateQuery), ResultHandler.ofBeanList(resultType, (Function)this.repository.beanColumnNameMapping));
    }

    public List<Map<String, Object>> list() {
        return (List)this.repository.sqlRunner.query(this.repository.buildAggregateSQL(this.beforeAggregateQuery, this.aggregationDefinition, this.afterAggregateQuery), ResultHandler.ofMapList((MapBuilder)this.repository.mapBuilder));
    }

    public <T> void forEach(Consumer<T> resultConsumer, Class<T> resultType) {
        this.repository.sqlRunner.query(this.repository.buildAggregateSQL(this.beforeAggregateQuery, this.aggregationDefinition, this.afterAggregateQuery), ResultHandler.ofBeanConsumer(resultType, (Function)this.repository.beanColumnNameMapping, resultConsumer));
    }

    public void forEach(Consumer<Map<String, Object>> resultConsumer) {
        this.repository.sqlRunner.query(this.repository.buildAggregateSQL(this.beforeAggregateQuery, this.aggregationDefinition, this.afterAggregateQuery), ResultHandler.ofMapConsumer((MapBuilder)this.repository.mapBuilder, resultConsumer));
    }

    public <T> T first(Class<T> resultType) {
        return (T)this.repository.sqlRunner.query(this.repository.buildAggregateFirstSQL(this.beforeAggregateQuery, this.aggregationDefinition, this.afterAggregateQuery), ResultHandler.ofBean(resultType, (Function)this.repository.beanColumnNameMapping));
    }

    public Map<String, Object> first() {
        return (Map)this.repository.sqlRunner.query(this.repository.buildAggregateFirstSQL(this.beforeAggregateQuery, this.aggregationDefinition, this.afterAggregateQuery), ResultHandler.ofMap((MapBuilder)this.repository.mapBuilder));
    }
}

