/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.sql_builder;

import cool.scx.data.field_policy.AssignField;
import cool.scx.data.field_policy.FieldPolicy;
import cool.scx.data.field_policy.FilterMode;
import cool.scx.data.field_policy.VirtualField;
import cool.scx.data.jdbc.mapping.AnnotationConfigColumn;
import cool.scx.data.jdbc.mapping.AnnotationConfigTable;
import cool.scx.jdbc.dialect.Dialect;
import cool.scx.jdbc.mapping.Column;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

class SQLBuilderHelper {
    SQLBuilderHelper() {
    }

    public static AnnotationConfigColumn[] filterByUpdateFieldPolicy(FieldPolicy fieldPolicy, AnnotationConfigTable table, Object entity) {
        AnnotationConfigColumn[] columns = SQLBuilderHelper.filterByFilterMode(fieldPolicy, table);
        AssignField[] assignFields = fieldPolicy.getAssignFields();
        columns = SQLBuilderHelper.filterByAssignFields(assignFields, table, columns);
        boolean globalIgnoreNull = fieldPolicy.getIgnoreNull();
        Map ignoreNulls = fieldPolicy.getIgnoreNulls();
        columns = SQLBuilderHelper.filterByFieldValueIsNull(entity, globalIgnoreNull, ignoreNulls, columns);
        return columns;
    }

    public static AnnotationConfigColumn[] filterByUpdateFieldPolicy(FieldPolicy fieldPolicy, AnnotationConfigTable table) {
        AnnotationConfigColumn[] columns = SQLBuilderHelper.filterByFilterMode(fieldPolicy, table);
        AssignField[] assignFields = fieldPolicy.getAssignFields();
        return SQLBuilderHelper.filterByAssignFields(assignFields, table, columns);
    }

    public static AnnotationConfigColumn[] filterByQueryFieldPolicy(FieldPolicy fieldPolicy, AnnotationConfigTable table) {
        AnnotationConfigColumn[] columns = SQLBuilderHelper.filterByFilterMode(fieldPolicy, table);
        VirtualField[] virtualFields = fieldPolicy.getVirtualFields();
        return SQLBuilderHelper.filterByVirtualFields(virtualFields, table, columns);
    }

    public static AnnotationConfigColumn[] filterByVirtualFields(VirtualField[] virtualFields, AnnotationConfigTable table, AnnotationConfigColumn ... columns) {
        if (virtualFields.length == 0) {
            return columns;
        }
        ArrayList result = new ArrayList();
        Collections.addAll(result, columns);
        for (VirtualField fieldName : virtualFields) {
            result.remove(table.getColumn(fieldName.virtualFieldName()));
        }
        return (AnnotationConfigColumn[])result.toArray(AnnotationConfigColumn[]::new);
    }

    public static AnnotationConfigColumn[] filterByFilterMode(FieldPolicy fieldPolicy, AnnotationConfigTable table) {
        FilterMode filterMode = fieldPolicy.getFilterMode();
        return switch (filterMode) {
            default -> throw new MatchException(null, null);
            case FilterMode.INCLUDED -> SQLBuilderHelper.filterByIncluded(fieldPolicy.getFieldNames(), table);
            case FilterMode.EXCLUDED -> SQLBuilderHelper.filterByExcluded(fieldPolicy.getFieldNames(), table);
        };
    }

    public static AnnotationConfigColumn[] filterByIncluded(String[] fieldNames, AnnotationConfigTable table) {
        if (fieldNames.length == 0) {
            return new AnnotationConfigColumn[0];
        }
        ArrayList<AnnotationConfigColumn> columns = new ArrayList<AnnotationConfigColumn>();
        for (String fieldName : fieldNames) {
            AnnotationConfigColumn column = table.getColumn(fieldName);
            if (column == null) continue;
            columns.add(column);
        }
        return (AnnotationConfigColumn[])columns.toArray(AnnotationConfigColumn[]::new);
    }

    public static AnnotationConfigColumn[] filterByExcluded(String[] fieldNames, AnnotationConfigTable table) {
        if (fieldNames.length == 0) {
            return table.columns();
        }
        ArrayList allColumns = new ArrayList();
        Collections.addAll(allColumns, table.columns());
        for (String fieldName : fieldNames) {
            allColumns.remove(table.getColumn(fieldName));
        }
        return (AnnotationConfigColumn[])allColumns.toArray(AnnotationConfigColumn[]::new);
    }

    private static AnnotationConfigColumn[] filterByFieldValueIsNull(Object entity, boolean globalIgnoreNull, Map<String, Boolean> ignoreNulls, AnnotationConfigColumn ... columns) {
        if (entity == null && globalIgnoreNull && ignoreNulls.isEmpty()) {
            return new AnnotationConfigColumn[0];
        }
        if (!globalIgnoreNull && ignoreNulls.isEmpty()) {
            return columns;
        }
        ArrayList<AnnotationConfigColumn> result = new ArrayList<AnnotationConfigColumn>();
        for (AnnotationConfigColumn column : columns) {
            Object value;
            String fieldName = column.javaField().name();
            Boolean ignoreNull = ignoreNulls.getOrDefault(fieldName, globalIgnoreNull);
            Object object = value = entity != null ? column.javaFieldValue(entity) : null;
            if (ignoreNull.booleanValue() && value == null) continue;
            result.add(column);
        }
        return (AnnotationConfigColumn[])result.toArray(AnnotationConfigColumn[]::new);
    }

    public static AnnotationConfigColumn[] filterByAssignFields(AssignField[] assignFields, AnnotationConfigTable table, AnnotationConfigColumn ... columns) {
        if (assignFields.length == 0) {
            return columns;
        }
        ArrayList result = new ArrayList();
        Collections.addAll(result, columns);
        for (AssignField fieldName : assignFields) {
            result.remove(table.getColumn(fieldName.fieldName()));
        }
        return (AnnotationConfigColumn[])result.toArray(AnnotationConfigColumn[]::new);
    }

    public static Object[] extractValues(AnnotationConfigColumn[] column, Object entity) {
        Object[] result = new Object[column.length];
        if (entity == null) {
            return result;
        }
        for (int i = 0; i < column.length; ++i) {
            result[i] = column[i].javaFieldValue(entity);
        }
        return result;
    }

    public static String joinWithQuoteIdentifier(Object[] values, Dialect dialect) {
        boolean isFirst = true;
        StringBuilder sb = new StringBuilder();
        for (Object value : values) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            if (value instanceof Column) {
                Column c = (Column)value;
                sb.append(dialect.quoteIdentifier(c.name()));
                continue;
            }
            sb.append(value.toString());
        }
        return sb.toString();
    }
}

