/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.sql_builder;

import cool.scx.common.util.ArrayUtils;
import cool.scx.common.util.RandomUtils;
import cool.scx.common.util.StringUtils;
import cool.scx.data.LockMode;
import cool.scx.data.field_policy.FieldPolicy;
import cool.scx.data.field_policy.VirtualField;
import cool.scx.data.jdbc.mapping.AnnotationConfigTable;
import cool.scx.data.jdbc.parser.JDBCOrderByParser;
import cool.scx.data.jdbc.parser.JDBCWhereParser;
import cool.scx.data.jdbc.sql_builder.SQLBuilderHelper;
import cool.scx.data.query.Query;
import cool.scx.data.query.WhereClause;
import cool.scx.jdbc.dialect.Dialect;
import cool.scx.jdbc.sql.SQL;

public class SelectSQLBuilder {
    private final AnnotationConfigTable table;
    private final Dialect dialect;
    private final JDBCWhereParser whereParser;
    private final JDBCOrderByParser orderByParser;

    public SelectSQLBuilder(AnnotationConfigTable table, Dialect dialect, JDBCWhereParser whereParser, JDBCOrderByParser orderByParser) {
        this.table = table;
        this.dialect = dialect;
        this.whereParser = whereParser;
        this.orderByParser = orderByParser;
    }

    public static String[] createVirtualSelectColumns(FieldPolicy fieldPolicy, Dialect dialect) {
        VirtualField[] fieldExpressions = fieldPolicy.getVirtualFields();
        String[] virtualSelectColumns = new String[fieldExpressions.length];
        int i = 0;
        for (VirtualField fieldExpression : fieldExpressions) {
            String fieldName = fieldExpression.virtualFieldName();
            String expression = fieldExpression.expression();
            virtualSelectColumns[i] = expression + " AS " + dialect.quoteIdentifier(fieldName);
            ++i;
        }
        return virtualSelectColumns;
    }

    public SQL buildSelectSQL(Query query, FieldPolicy fieldPolicy, LockMode lockMode) {
        Object[] selectColumns = SQLBuilderHelper.filterByQueryFieldPolicy(fieldPolicy, this.table);
        String[] virtualSelectColumns = SelectSQLBuilder.createVirtualSelectColumns(fieldPolicy, this.dialect);
        Object[] finalSelectColumns = ArrayUtils.tryConcatAny((Object[])selectColumns, (Object[])virtualSelectColumns);
        WhereClause whereClause = this.whereParser.parse(query.getWhere());
        String[] orderByClauses = this.orderByParser.parse(query.getOrderBys());
        String sql = this.GetSelectSQL(finalSelectColumns, whereClause.expression(), orderByClauses, query.getOffset(), query.getLimit(), lockMode);
        return SQL.sql((String)sql, (Object[])whereClause.params());
    }

    public SQL buildSelectFirstSQL(Query query, FieldPolicy fieldPolicy, LockMode lockMode) {
        Object[] selectColumns = SQLBuilderHelper.filterByQueryFieldPolicy(fieldPolicy, this.table);
        String[] virtualSelectColumns = SelectSQLBuilder.createVirtualSelectColumns(fieldPolicy, this.dialect);
        Object[] finalSelectColumns = ArrayUtils.tryConcatAny((Object[])selectColumns, (Object[])virtualSelectColumns);
        WhereClause whereClause = this.whereParser.parse(query.getWhere());
        String[] orderByClauses = this.orderByParser.parse(query.getOrderBys());
        String sql = this.GetSelectSQL(finalSelectColumns, whereClause.expression(), orderByClauses, null, 1L, lockMode);
        return SQL.sql((String)sql, (Object[])whereClause.params());
    }

    public SQL buildSelectFirstSQLWithAlias(Query query, FieldPolicy fieldPolicy) {
        SQL sql0 = this.buildSelectFirstSQL(query, fieldPolicy);
        String sql = this.GetWrapperSelectSQL(sql0.sql());
        return SQL.sql((String)sql, (Object[])sql0.params());
    }

    public SQL buildSelectSQLWithAlias(Query query, FieldPolicy fieldPolicy) {
        SQL sql0 = this.buildSelectSQL(query, fieldPolicy);
        String sql = this.GetWrapperSelectSQL(sql0.sql());
        return SQL.sql((String)sql, (Object[])sql0.params());
    }

    public SQL buildSelectSQL(Query query, FieldPolicy fieldPolicy) {
        return this.buildSelectSQL(query, fieldPolicy, null);
    }

    public SQL buildSelectFirstSQL(Query query, FieldPolicy fieldPolicy) {
        return this.buildSelectFirstSQL(query, fieldPolicy, null);
    }

    private String GetWrapperSelectSQL(String sql) {
        return "SELECT * FROM (" + sql + ") AS " + this.getRandomTableName();
    }

    private String GetSelectSQL(Object[] selectColumns, String whereClause, String[] orderByClauses, Long offset, Long limit, LockMode lockMode) {
        if (selectColumns.length == 0) {
            throw new IllegalArgumentException("Select \u5b50\u53e5\u9519\u8bef : \u5f85\u67e5\u8be2\u7684\u6570\u636e\u5217 \u4e0d\u80fd\u4e3a\u7a7a !!!");
        }
        Object sql = "SELECT " + this.getSelectColumns(selectColumns) + " FROM " + this.getTableName() + this.getWhereClause(whereClause) + this.getOrderByClause(orderByClauses);
        sql = this.dialect.applyLimit((String)sql, offset, limit);
        if (lockMode == LockMode.SHARED) {
            sql = this.dialect.applySharedLock((String)sql);
        } else if (lockMode == LockMode.EXCLUSIVE) {
            sql = this.dialect.applyExclusiveLock((String)sql);
        }
        return sql;
    }

    private String getSelectColumns(Object[] selectColumns) {
        return SQLBuilderHelper.joinWithQuoteIdentifier(selectColumns, this.dialect);
    }

    private String getTableName() {
        return this.dialect.quoteIdentifier(this.table.name());
    }

    private String getRandomTableName() {
        return this.dialect.quoteIdentifier(this.table.name() + "_" + RandomUtils.randomString((int)6));
    }

    private String getWhereClause(String whereClause) {
        return StringUtils.notEmpty((String)whereClause) ? " WHERE " + whereClause : "";
    }

    private String getOrderByClause(String[] orderByClauses) {
        return orderByClauses != null && orderByClauses.length != 0 ? " ORDER BY " + String.join((CharSequence)", ", orderByClauses) : "";
    }
}

