/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.sql_builder;

import cool.scx.common.util.ArrayUtils;
import cool.scx.common.util.StringUtils;
import cool.scx.data.field_policy.AssignField;
import cool.scx.data.field_policy.FieldPolicy;
import cool.scx.data.jdbc.mapping.AnnotationConfigColumn;
import cool.scx.data.jdbc.mapping.AnnotationConfigTable;
import cool.scx.data.jdbc.parser.JDBCColumnNameParser;
import cool.scx.data.jdbc.parser.JDBCOrderByParser;
import cool.scx.data.jdbc.parser.JDBCWhereParser;
import cool.scx.data.jdbc.sql_builder.SQLBuilderHelper;
import cool.scx.data.query.Query;
import cool.scx.data.query.WhereClause;
import cool.scx.jdbc.dialect.Dialect;
import cool.scx.jdbc.mapping.Column;
import cool.scx.jdbc.sql.SQL;

public class UpdateSQLBuilder {
    private final AnnotationConfigTable table;
    private final Dialect dialect;
    private final JDBCColumnNameParser columnNameParser;
    private final JDBCWhereParser whereParser;
    private final JDBCOrderByParser orderByParser;

    public UpdateSQLBuilder(AnnotationConfigTable table, Dialect dialect, JDBCColumnNameParser columnNameParser, JDBCWhereParser whereParser, JDBCOrderByParser orderByParser) {
        this.table = table;
        this.dialect = dialect;
        this.columnNameParser = columnNameParser;
        this.whereParser = whereParser;
        this.orderByParser = orderByParser;
    }

    public static String[] createUpdateSetClauses(Column[] columns, Dialect dialect) {
        String[] result = new String[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            result[i] = dialect.quoteIdentifier(columns[i].name()) + " = ?";
        }
        return result;
    }

    public static String[] createUpdateSetExpressionsClauses(FieldPolicy fieldPolicy, JDBCColumnNameParser columnNameParser) {
        AssignField[] assignFields = fieldPolicy.getAssignFields();
        String[] result = new String[assignFields.length];
        int i = 0;
        for (AssignField entry : assignFields) {
            String fieldName = entry.fieldName();
            String expression = entry.expression();
            result[i] = columnNameParser.parseColumnName(fieldName, false) + " = " + expression;
            ++i;
        }
        return result;
    }

    public SQL buildUpdateSQL(Object entity, FieldPolicy updateFilter, Query query) {
        if (query.getWhere() == null) {
            throw new IllegalArgumentException("\u66f4\u65b0\u6570\u636e\u65f6 \u5fc5\u987b\u6307\u5b9a \u5220\u9664\u6761\u4ef6 \u6216 \u81ea\u5b9a\u4e49\u7684 where \u8bed\u53e5 !!!");
        }
        AnnotationConfigColumn[] updateSetColumns = SQLBuilderHelper.filterByUpdateFieldPolicy(updateFilter, this.table, entity);
        Object[] updateSetClauses = UpdateSQLBuilder.createUpdateSetClauses((Column[])updateSetColumns, this.dialect);
        Object[] updateSetExpressionsColumns = UpdateSQLBuilder.createUpdateSetExpressionsClauses(updateFilter, this.columnNameParser);
        String[] finalUpdateSetClauses = (String[])ArrayUtils.tryConcat((Object[])updateSetClauses, (Object[])updateSetExpressionsColumns);
        WhereClause whereClause = this.whereParser.parse(query.getWhere());
        String[] orderByClauses = this.orderByParser.parse(query.getOrderBys());
        String sql = this.GetUpdateSQL(finalUpdateSetClauses, whereClause.expression(), orderByClauses, query.getLimit());
        Object[] entityParams = SQLBuilderHelper.extractValues(updateSetColumns, entity);
        Object[] finalParams = ArrayUtils.tryConcat((Object[])entityParams, (Object[])whereClause.params());
        return SQL.sql((String)sql, (Object[])finalParams);
    }

    private String GetUpdateSQL(String[] updateSetClauses, String whereClause, String[] orderByClauses, Long limit) {
        if (updateSetClauses.length == 0) {
            throw new IllegalArgumentException("Set \u5b50\u53e5\u9519\u8bef : \u5f85\u66f4\u65b0\u7684\u6570\u636e\u5217 \u4e0d\u80fd\u4e3a\u7a7a !!!");
        }
        String sql = "UPDATE " + this.getTableName() + " SET " + String.join((CharSequence)", ", updateSetClauses) + this.getWhereClause(whereClause) + this.getOrderByClause(orderByClauses);
        return this.dialect.applyLimit(sql, null, limit);
    }

    private String getTableName() {
        return this.dialect.quoteIdentifier(this.table.name());
    }

    private String getWhereClause(String whereClause) {
        return StringUtils.notEmpty((String)whereClause) ? " WHERE " + whereClause : "";
    }

    private String getOrderByClause(String[] orderByClauses) {
        return orderByClauses != null && orderByClauses.length != 0 ? " ORDER BY " + String.join((CharSequence)", ", orderByClauses) : "";
    }
}

