/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc;

import cool.scx.data.Finder;
import cool.scx.data.LockMode;
import cool.scx.data.exception.DataAccessException;
import cool.scx.data.field_policy.FieldPolicy;
import cool.scx.data.jdbc.JDBCRepository;
import cool.scx.data.query.Query;
import cool.scx.function.Function1Void;
import cool.scx.jdbc.result_handler.ResultHandler;
import cool.scx.jdbc.result_handler.map_builder.MapBuilder;
import cool.scx.jdbc.sql.SQLRunnerException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class JDBCFinder<Entity>
implements Finder<Entity> {
    private final JDBCRepository<Entity> repository;
    private final Query query;
    private final FieldPolicy fieldPolicy;
    private final LockMode lockMode;

    public JDBCFinder(JDBCRepository<Entity> repository, Query query, FieldPolicy fieldPolicy) {
        this(repository, query, fieldPolicy, null);
    }

    public JDBCFinder(JDBCRepository<Entity> repository, Query query, FieldPolicy fieldPolicy, LockMode lockMode) {
        this.repository = repository;
        this.query = query;
        this.fieldPolicy = fieldPolicy;
        this.lockMode = lockMode;
    }

    public List<Entity> list() throws DataAccessException {
        try {
            return (List)this.repository.sqlRunner.query(this.repository.buildSelectSQL(this.query, this.fieldPolicy, this.lockMode), this.repository.entityBeanListHandler);
        }
        catch (SQLRunnerException e) {
            throw new DataAccessException((Throwable)e.getCause());
        }
    }

    public <T> List<T> list(Class<T> resultType) throws DataAccessException {
        try {
            return (List)this.repository.sqlRunner.query(this.repository.buildSelectSQL(this.query, this.fieldPolicy, this.lockMode), ResultHandler.ofBeanList(resultType, (Function)this.repository.beanColumnNameMapping));
        }
        catch (SQLRunnerException e) {
            throw new DataAccessException((Throwable)e.getCause());
        }
    }

    public List<Map<String, Object>> listMap() throws DataAccessException {
        try {
            return (List)this.repository.sqlRunner.query(this.repository.buildSelectSQL(this.query, this.fieldPolicy, this.lockMode), ResultHandler.ofMapList((MapBuilder)this.repository.mapBuilder));
        }
        catch (SQLRunnerException e) {
            throw new DataAccessException((Throwable)e.getCause());
        }
    }

    public <X extends Throwable> void forEach(Function1Void<Entity, X> entityConsumer) throws DataAccessException, X {
        try {
            this.repository.sqlRunner.query(this.repository.buildSelectSQL(this.query, this.fieldPolicy, this.lockMode), ResultHandler.ofBeanConsumer(this.repository.beanBuilder, entityConsumer));
        }
        catch (SQLRunnerException e) {
            throw new DataAccessException((Throwable)e.getCause());
        }
    }

    public <T, X extends Throwable> void forEach(Function1Void<T, X> entityConsumer, Class<T> resultType) throws DataAccessException, X {
        try {
            this.repository.sqlRunner.query(this.repository.buildSelectSQL(this.query, this.fieldPolicy, this.lockMode), ResultHandler.ofBeanConsumer(resultType, (Function)this.repository.beanColumnNameMapping, entityConsumer));
        }
        catch (SQLRunnerException e) {
            throw new DataAccessException((Throwable)e.getCause());
        }
    }

    public <X extends Throwable> void forEachMap(Function1Void<Map<String, Object>, X> entityConsumer) throws DataAccessException, X {
        try {
            this.repository.sqlRunner.query(this.repository.buildSelectSQL(this.query, this.fieldPolicy, this.lockMode), ResultHandler.ofMapConsumer((MapBuilder)this.repository.mapBuilder, entityConsumer));
        }
        catch (SQLRunnerException e) {
            throw new DataAccessException((Throwable)e.getCause());
        }
    }

    public Entity first() throws DataAccessException {
        try {
            return (Entity)this.repository.sqlRunner.query(this.repository.buildSelectFirstSQL(this.query, this.fieldPolicy, this.lockMode), this.repository.entityBeanHandler);
        }
        catch (SQLRunnerException e) {
            throw new DataAccessException((Throwable)e.getCause());
        }
    }

    public <T> T first(Class<T> resultType) throws DataAccessException {
        try {
            return (T)this.repository.sqlRunner.query(this.repository.buildSelectFirstSQL(this.query, this.fieldPolicy, this.lockMode), ResultHandler.ofBean(resultType, (Function)this.repository.beanColumnNameMapping));
        }
        catch (SQLRunnerException e) {
            throw new DataAccessException((Throwable)e.getCause());
        }
    }

    public Map<String, Object> firstMap() throws DataAccessException {
        try {
            return (Map)this.repository.sqlRunner.query(this.repository.buildSelectFirstSQL(this.query, this.fieldPolicy, this.lockMode), ResultHandler.ofMap((MapBuilder)this.repository.mapBuilder));
        }
        catch (SQLRunnerException e) {
            throw new DataAccessException((Throwable)e.getCause());
        }
    }

    public long count() throws DataAccessException {
        try {
            return (Long)this.repository.sqlRunner.query(this.repository.buildCountSQL(this.query), this.repository.countResultHandler);
        }
        catch (SQLRunnerException e) {
            throw new DataAccessException((Throwable)e.getCause());
        }
    }
}

