/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.mapping;

import cool.scx.collections.multi_map.IMultiMapEntry;
import cool.scx.collections.multi_map.MultiMap;
import cool.scx.common.constant.AnnotationValues;
import cool.scx.common.util.CaseUtils;
import cool.scx.data.jdbc.annotation.NoColumn;
import cool.scx.data.jdbc.annotation.Table;
import cool.scx.data.jdbc.mapping.AnnotationConfigColumn;
import cool.scx.data.jdbc.mapping.EntityTable;
import cool.scx.reflect.AccessModifier;
import cool.scx.reflect.ClassInfo;
import cool.scx.reflect.ClassKind;
import cool.scx.reflect.FieldInfo;
import cool.scx.reflect.ScxReflect;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class AnnotationConfigTable<Entity>
implements EntityTable<Entity> {
    private final AnnotationConfigColumn[] columns;
    private final String name;
    private final Map<String, AnnotationConfigColumn> columnMap;
    private final Class<Entity> entityClass;

    public AnnotationConfigTable(Class<Entity> entityClass) {
        this.entityClass = entityClass;
        this.name = AnnotationConfigTable.initTableName(entityClass);
        this.columns = AnnotationConfigTable.initAllColumns(entityClass);
        this.columnMap = AnnotationConfigTable.initAllColumnMap(this.columns);
    }

    public static String initTableName(Class<?> clazz) {
        String _tableName;
        Table table = clazz.getAnnotation(Table.class);
        String defaultTableName = CaseUtils.toSnake((String)clazz.getSimpleName());
        if (table != null && (_tableName = AnnotationValues.getRealValue((String)table.value())) != null) {
            return _tableName;
        }
        return defaultTableName;
    }

    private static AnnotationConfigColumn[] initAllColumns(Class<?> clazz) {
        ClassInfo classInfo = (ClassInfo)ScxReflect.typeOf(clazz);
        FieldInfo[] fields = classInfo.classKind() == ClassKind.RECORD ? classInfo.allFields() : (FieldInfo[])Stream.of(classInfo.allFields()).filter(c -> c.accessModifier() == AccessModifier.PUBLIC).toArray(FieldInfo[]::new);
        List<AnnotationConfigColumn> list = Stream.of(fields).filter(field -> field.findAnnotation(NoColumn.class) == null).map(AnnotationConfigColumn::new).toList();
        AnnotationConfigTable.checkDuplicateColumnName(list, clazz);
        return (AnnotationConfigColumn[])list.toArray(AnnotationConfigColumn[]::new);
    }

    private static Map<String, AnnotationConfigColumn> initAllColumnMap(AnnotationConfigColumn[] infos) {
        HashMap<String, AnnotationConfigColumn> map = new HashMap<String, AnnotationConfigColumn>();
        for (AnnotationConfigColumn info : infos) {
            map.put(info.name(), info);
        }
        for (AnnotationConfigColumn info : infos) {
            map.put(info.javaField().name(), info);
        }
        return map;
    }

    private static void checkDuplicateColumnName(List<AnnotationConfigColumn> list, Class<?> clazz) {
        MultiMap multiMap = new MultiMap();
        for (AnnotationConfigColumn info : list) {
            multiMap.add((Object)info.name(), (Object)info);
        }
        for (IMultiMapEntry entry : multiMap) {
            List v = entry.values();
            if (v.size() <= 1) continue;
            throw new IllegalArgumentException("\u91cd\u590d\u7684 columnName !!! Class -> " + clazz.getName() + ", Field -> " + String.valueOf(v.stream().map(c -> c.javaField().name()).toList()));
        }
    }

    public String name() {
        return this.name;
    }

    @Override
    public Class<Entity> entityClass() {
        return this.entityClass;
    }

    public AnnotationConfigColumn[] columns() {
        return this.columns;
    }

    @Override
    public AnnotationConfigColumn getColumn(String column) {
        return this.columnMap.get(column);
    }
}

