/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc;

import cool.scx.data.Aggregator;
import cool.scx.data.aggregation.Aggregation;
import cool.scx.data.exception.DataAccessException;
import cool.scx.data.jdbc.JDBCRepository;
import cool.scx.data.query.Query;
import cool.scx.function.ConsumerX;
import cool.scx.jdbc.result_handler.ResultHandler;
import cool.scx.jdbc.result_handler.map_builder.MapBuilder;
import cool.scx.jdbc.sql.SQLRunnerException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class JDBCAggregator
implements Aggregator {
    private final JDBCRepository<?> repository;
    private final Query beforeAggregateQuery;
    private final Aggregation aggregationDefinition;
    private final Query afterAggregateQuery;

    public JDBCAggregator(JDBCRepository<?> repository, Query beforeAggregateQuery, Aggregation aggregationDefinition, Query afterAggregateQuery) {
        this.repository = repository;
        this.beforeAggregateQuery = beforeAggregateQuery;
        this.aggregationDefinition = aggregationDefinition;
        this.afterAggregateQuery = afterAggregateQuery;
    }

    public <T> List<T> list(Class<T> resultType) throws DataAccessException {
        try {
            return (List)this.repository.sqlRunner.query(this.repository.buildAggregateSQL(this.beforeAggregateQuery, this.aggregationDefinition, this.afterAggregateQuery), ResultHandler.ofBeanList(resultType, (Function)this.repository.beanColumnNameMapping));
        }
        catch (SQLRunnerException e) {
            throw new DataAccessException((Throwable)e.getCause());
        }
    }

    public List<Map<String, Object>> list() throws DataAccessException {
        try {
            return (List)this.repository.sqlRunner.query(this.repository.buildAggregateSQL(this.beforeAggregateQuery, this.aggregationDefinition, this.afterAggregateQuery), ResultHandler.ofMapList((MapBuilder)this.repository.mapBuilder));
        }
        catch (SQLRunnerException e) {
            throw new DataAccessException((Throwable)e.getCause());
        }
    }

    public <T, X extends Throwable> void forEach(ConsumerX<T, X> resultConsumer, Class<T> resultType) throws DataAccessException, X {
        try {
            this.repository.sqlRunner.query(this.repository.buildAggregateSQL(this.beforeAggregateQuery, this.aggregationDefinition, this.afterAggregateQuery), ResultHandler.ofBeanConsumer(resultType, (Function)this.repository.beanColumnNameMapping, resultConsumer));
        }
        catch (SQLRunnerException e) {
            throw new DataAccessException((Throwable)e.getCause());
        }
    }

    public <X extends Throwable> void forEach(ConsumerX<Map<String, Object>, X> resultConsumer) throws DataAccessException, X {
        try {
            this.repository.sqlRunner.query(this.repository.buildAggregateSQL(this.beforeAggregateQuery, this.aggregationDefinition, this.afterAggregateQuery), ResultHandler.ofMapConsumer((MapBuilder)this.repository.mapBuilder, resultConsumer));
        }
        catch (SQLRunnerException e) {
            throw new DataAccessException((Throwable)e.getCause());
        }
    }

    public <T> T first(Class<T> resultType) throws DataAccessException {
        try {
            return (T)this.repository.sqlRunner.query(this.repository.buildAggregateFirstSQL(this.beforeAggregateQuery, this.aggregationDefinition, this.afterAggregateQuery), ResultHandler.ofBean(resultType, (Function)this.repository.beanColumnNameMapping));
        }
        catch (SQLRunnerException e) {
            throw new DataAccessException((Throwable)e.getCause());
        }
    }

    public Map<String, Object> first() throws DataAccessException {
        try {
            return (Map)this.repository.sqlRunner.query(this.repository.buildAggregateFirstSQL(this.beforeAggregateQuery, this.aggregationDefinition, this.afterAggregateQuery), ResultHandler.ofMap((MapBuilder)this.repository.mapBuilder));
        }
        catch (SQLRunnerException e) {
            throw new DataAccessException((Throwable)e.getCause());
        }
    }
}

