/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc;

import cool.scx.data.AggregatableRepository;
import cool.scx.data.Aggregator;
import cool.scx.data.Finder;
import cool.scx.data.LockMode;
import cool.scx.data.LockableRepository;
import cool.scx.data.aggregation.Aggregation;
import cool.scx.data.exception.DataAccessException;
import cool.scx.data.field_policy.FieldPolicy;
import cool.scx.data.jdbc.JDBCAggregator;
import cool.scx.data.jdbc.JDBCFinder;
import cool.scx.data.jdbc.column_name_mapping.BeanColumnNameMapping;
import cool.scx.data.jdbc.column_name_mapping.MapFieldNameMapping;
import cool.scx.data.jdbc.mapping.AnnotationConfigTable;
import cool.scx.data.jdbc.mapping.EntityTable;
import cool.scx.data.jdbc.parser.JDBCColumnNameParser;
import cool.scx.data.jdbc.parser.JDBCGroupByParser;
import cool.scx.data.jdbc.parser.JDBCOrderByParser;
import cool.scx.data.jdbc.parser.JDBCWhereParser;
import cool.scx.data.jdbc.sql_builder.AggregateSQLBuilder;
import cool.scx.data.jdbc.sql_builder.CountSQLBuilder;
import cool.scx.data.jdbc.sql_builder.DeleteSQLBuilder;
import cool.scx.data.jdbc.sql_builder.InsertSQLBuilder;
import cool.scx.data.jdbc.sql_builder.SelectSQLBuilder;
import cool.scx.data.jdbc.sql_builder.UpdateSQLBuilder;
import cool.scx.data.query.Query;
import cool.scx.jdbc.JDBCContext;
import cool.scx.jdbc.dialect.Dialect;
import cool.scx.jdbc.result_handler.ResultHandler;
import cool.scx.jdbc.result_handler.bean_builder.BeanBuilder;
import cool.scx.jdbc.result_handler.map_builder.MapBuilder;
import cool.scx.jdbc.sql.SQL;
import cool.scx.jdbc.sql.SQLRunner;
import cool.scx.jdbc.sql.SQLRunnerException;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class JDBCRepository<Entity>
implements AggregatableRepository<Entity, Long>,
LockableRepository<Entity, Long> {
    final Class<Entity> entityClass;
    final JDBCContext jdbcContext;
    final EntityTable<Entity> table;
    final SQLRunner sqlRunner;
    final BeanColumnNameMapping beanColumnNameMapping;
    final MapFieldNameMapping mapFieldNameMapping;
    final BeanBuilder<Entity> beanBuilder;
    final MapBuilder mapBuilder;
    final ResultHandler<List<Entity>, RuntimeException> entityBeanListHandler;
    final ResultHandler<Entity, RuntimeException> entityBeanHandler;
    final ResultHandler<Long, RuntimeException> countResultHandler;
    final InsertSQLBuilder insertSQLBuilder;
    final SelectSQLBuilder selectSQLBuilder;
    final UpdateSQLBuilder updateSQLBuilder;
    final DeleteSQLBuilder deleteSQLBuilder;
    final CountSQLBuilder countSQLBuilder;
    final AggregateSQLBuilder aggregateSQLBuilder;

    public JDBCRepository(Class<Entity> entityClass, JDBCContext jdbcContext) {
        this(new AnnotationConfigTable<Entity>(entityClass), jdbcContext);
    }

    public JDBCRepository(EntityTable<Entity> table, JDBCContext jdbcContext) {
        this.entityClass = table.entityClass();
        this.jdbcContext = jdbcContext;
        this.table = table;
        this.sqlRunner = jdbcContext.sqlRunner();
        this.beanColumnNameMapping = new BeanColumnNameMapping(table);
        this.mapFieldNameMapping = new MapFieldNameMapping(table);
        this.beanBuilder = BeanBuilder.of(this.entityClass, (Function)this.beanColumnNameMapping);
        this.mapBuilder = MapBuilder.of((Function)this.mapFieldNameMapping);
        this.entityBeanListHandler = ResultHandler.ofBeanList(this.beanBuilder);
        this.entityBeanHandler = ResultHandler.ofBean(this.beanBuilder);
        this.countResultHandler = ResultHandler.ofSingleValue((String)"count", Long.class);
        Dialect dialect = jdbcContext.dialect();
        JDBCColumnNameParser columnNameParser = new JDBCColumnNameParser(table, dialect);
        JDBCWhereParser whereParser = new JDBCWhereParser(columnNameParser, dialect);
        JDBCGroupByParser groupByParser = new JDBCGroupByParser(columnNameParser);
        JDBCOrderByParser orderByParser = new JDBCOrderByParser(columnNameParser);
        this.insertSQLBuilder = new InsertSQLBuilder(table, dialect, columnNameParser);
        this.selectSQLBuilder = new SelectSQLBuilder(table, dialect, whereParser, orderByParser);
        this.updateSQLBuilder = new UpdateSQLBuilder(table, dialect, columnNameParser, whereParser, orderByParser);
        this.deleteSQLBuilder = new DeleteSQLBuilder(table, dialect, whereParser, orderByParser);
        this.countSQLBuilder = new CountSQLBuilder(table, dialect, whereParser);
        this.aggregateSQLBuilder = new AggregateSQLBuilder(table, dialect, whereParser, groupByParser, orderByParser);
    }

    public final Long add(Entity entity, FieldPolicy fieldPolicy) throws DataAccessException {
        try {
            return this.sqlRunner.update(this.buildInsertSQL(entity, fieldPolicy)).firstGeneratedKey();
        }
        catch (SQLRunnerException e) {
            throw new DataAccessException((Throwable)e.getCause());
        }
    }

    public final List<Long> add(Collection<Entity> entityList, FieldPolicy fieldPolicy) throws DataAccessException {
        try {
            return this.sqlRunner.updateBatch(this.buildInsertBatchSQL(entityList, fieldPolicy)).generatedKeys();
        }
        catch (SQLRunnerException e) {
            throw new DataAccessException((Throwable)e.getCause());
        }
    }

    public final Finder<Entity> finder(Query query, FieldPolicy fieldPolicy, LockMode lockMode) {
        return new JDBCFinder(this, query, fieldPolicy, lockMode);
    }

    public final Finder<Entity> finder(Query query, FieldPolicy fieldPolicy) {
        return new JDBCFinder(this, query, fieldPolicy);
    }

    public final long update(Entity entity, FieldPolicy fieldPolicy, Query query) throws DataAccessException {
        try {
            return this.sqlRunner.update(this.buildUpdateSQL(entity, fieldPolicy, query)).affectedItemsCount();
        }
        catch (SQLRunnerException e) {
            throw new DataAccessException((Throwable)e.getCause());
        }
    }

    public final long delete(Query query) throws DataAccessException {
        try {
            return this.sqlRunner.update(this.buildDeleteSQL(query)).affectedItemsCount();
        }
        catch (SQLRunnerException e) {
            throw new DataAccessException((Throwable)e.getCause());
        }
    }

    public final void clear() throws DataAccessException {
        try {
            this.sqlRunner.execute(SQL.sql((String)("truncate " + this.table.name()), (Object[])new Object[0]));
        }
        catch (SQLRunnerException e) {
            throw new DataAccessException((Throwable)e.getCause());
        }
    }

    public final Aggregator aggregator(Query beforeAggregateQuery, Aggregation aggregation, Query afterAggregateQuery) {
        return new JDBCAggregator(this, beforeAggregateQuery, aggregation, afterAggregateQuery);
    }

    public final Class<Entity> entityClass() {
        return this.entityClass;
    }

    public final EntityTable<Entity> table() {
        return this.table;
    }

    public final SQLRunner sqlRunner() {
        return this.sqlRunner;
    }

    public BeanBuilder<Entity> beanBuilder() {
        return this.beanBuilder;
    }

    public ResultHandler<List<Entity>, RuntimeException> entityBeanListHandler() {
        return this.entityBeanListHandler;
    }

    public ResultHandler<Entity, RuntimeException> entityBeanHandler() {
        return this.entityBeanHandler;
    }

    public JDBCContext jdbcContext() {
        return this.jdbcContext;
    }

    public SQL buildInsertSQL(Entity entity, FieldPolicy fieldPolicy) {
        return this.insertSQLBuilder.buildInsertSQL(entity, fieldPolicy);
    }

    public SQL buildInsertBatchSQL(Collection<? extends Entity> entityList, FieldPolicy fieldPolicy) {
        return this.insertSQLBuilder.buildInsertBatchSQL(entityList, fieldPolicy);
    }

    public SQL buildSelectSQL(Query query, FieldPolicy fieldPolicy) {
        return this.selectSQLBuilder.buildSelectSQL(query, fieldPolicy);
    }

    public SQL buildSelectFirstSQL(Query query, FieldPolicy fieldPolicy) {
        return this.selectSQLBuilder.buildSelectFirstSQL(query, fieldPolicy);
    }

    public SQL buildUpdateSQL(Entity entity, FieldPolicy fieldPolicy, Query query) {
        return this.updateSQLBuilder.buildUpdateSQL(entity, fieldPolicy, query);
    }

    public SQL buildDeleteSQL(Query query) {
        return this.deleteSQLBuilder.buildDeleteSQL(query);
    }

    public SQL buildCountSQL(Query query) {
        return this.countSQLBuilder.buildCountSQL(query);
    }

    public SQL buildSelectFirstSQLWithAlias(Query query, FieldPolicy fieldPolicy) {
        return this.selectSQLBuilder.buildSelectFirstSQLWithAlias(query, fieldPolicy);
    }

    public SQL buildSelectSQLWithAlias(Query query, FieldPolicy fieldPolicy) {
        return this.selectSQLBuilder.buildSelectSQLWithAlias(query, fieldPolicy);
    }

    public SQL buildAggregateSQL(Query beforeAggregateQuery, Aggregation aggregation, Query afterAggregateQuery) {
        return this.aggregateSQLBuilder.buildAggregateSQL(beforeAggregateQuery, aggregation, afterAggregateQuery);
    }

    public SQL buildAggregateFirstSQL(Query beforeAggregateQuery, Aggregation aggregation, Query afterAggregateQuery) {
        return this.aggregateSQLBuilder.buildAggregateFirstSQL(beforeAggregateQuery, aggregation, afterAggregateQuery);
    }

    public SQL buildSelectSQL(Query query, FieldPolicy fieldPolicy, LockMode lockMode) {
        return this.selectSQLBuilder.buildSelectSQL(query, fieldPolicy, lockMode);
    }

    public SQL buildSelectFirstSQL(Query query, FieldPolicy fieldPolicy, LockMode lockMode) {
        return this.selectSQLBuilder.buildSelectFirstSQL(query, fieldPolicy, lockMode);
    }
}

