/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc;

import cool.scx.data.context.TransactionManager;
import cool.scx.data.exception.DataAccessException;
import cool.scx.data.jdbc.JDBCTransactionContext;
import cool.scx.function.CallableX;
import cool.scx.function.ConsumerX;
import cool.scx.function.FunctionX;
import cool.scx.function.RunnableX;
import cool.scx.jdbc.JDBCContext;
import cool.scx.jdbc.sql.SQLRunnerException;
import java.sql.Connection;

public class JDBCTransactionManager
implements TransactionManager<JDBCTransactionContext> {
    private final JDBCContext jdbcContext;

    public JDBCTransactionManager(JDBCContext jdbcContext) {
        this.jdbcContext = jdbcContext;
    }

    public <T, X extends Throwable> T withTransaction(FunctionX<JDBCTransactionContext, T, X> handler) throws DataAccessException, X {
        try {
            return (T)this.jdbcContext.sqlRunner().withTransaction(con -> handler.apply((Object)new JDBCTransactionContext((Connection)con)));
        }
        catch (SQLRunnerException e) {
            throw new DataAccessException((Throwable)e.getCause());
        }
    }

    public <X extends Throwable> void withTransaction(ConsumerX<JDBCTransactionContext, X> handler) throws DataAccessException, X {
        try {
            this.jdbcContext.sqlRunner().withTransaction(con -> handler.accept((Object)new JDBCTransactionContext((Connection)con)));
        }
        catch (SQLRunnerException e) {
            throw new DataAccessException((Throwable)e.getCause());
        }
    }

    public <T, X extends Throwable> T autoTransaction(CallableX<T, X> handler) throws DataAccessException, X {
        try {
            return (T)this.jdbcContext.sqlRunner().autoTransaction(handler);
        }
        catch (SQLRunnerException e) {
            throw new DataAccessException((Throwable)e.getCause());
        }
    }

    public <X extends Throwable> void autoTransaction(RunnableX<X> handler) throws DataAccessException, X {
        try {
            this.jdbcContext.sqlRunner().autoTransaction(handler);
        }
        catch (SQLRunnerException e) {
            throw new DataAccessException((Throwable)e.getCause());
        }
    }

    public <T, X extends Throwable> T autoContext(CallableX<T, X> handler) throws DataAccessException, X {
        try {
            return (T)this.jdbcContext.sqlRunner().autoContext(handler);
        }
        catch (SQLRunnerException e) {
            throw new DataAccessException((Throwable)e.getCause());
        }
    }

    public <X extends Throwable> void autoContext(RunnableX<X> handler) throws DataAccessException, X {
        try {
            this.jdbcContext.sqlRunner().autoContext(handler);
        }
        catch (SQLRunnerException e) {
            throw new DataAccessException((Throwable)e.getCause());
        }
    }
}

