/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.mapping;

import cool.scx.common.constant.AnnotationValues;
import cool.scx.data.jdbc.annotation.Column;
import cool.scx.data.jdbc.mapping.AnnotationConfigDataType;
import cool.scx.data.jdbc.mapping.EntityColumn;
import cool.scx.reflect.FieldInfo;

public class AnnotationConfigColumn
implements EntityColumn {
    private final FieldInfo javaField;
    private final String columnName;
    private final AnnotationConfigDataType dataType;
    private final String defaultValue;
    private final String onUpdate;
    private final boolean notNull;
    private final boolean autoIncrement;
    private final boolean primary;
    private final boolean unique;
    private final boolean index;

    public AnnotationConfigColumn(FieldInfo javaField) {
        this.javaField = javaField;
        this.javaField.setAccessible(true);
        Column column = (Column)javaField.findAnnotation(Column.class);
        String defaultColumnName = javaField.name();
        AnnotationConfigDataType defaultDataType = new AnnotationConfigDataType(this.javaField.fieldType());
        if (column != null) {
            String _columnName = AnnotationValues.getRealValue((String)column.columnName());
            String _defaultValue = AnnotationValues.getRealValue((String)column.defaultValue());
            String _onUpdate = AnnotationValues.getRealValue((String)column.onUpdate());
            this.columnName = _columnName != null ? _columnName : defaultColumnName;
            this.dataType = column.dataType().length > 0 ? new AnnotationConfigDataType(column.dataType()[0]) : defaultDataType;
            this.defaultValue = _defaultValue;
            this.onUpdate = _onUpdate;
            this.notNull = column.notNull();
            this.autoIncrement = column.autoIncrement();
            this.primary = column.primary();
            this.unique = column.unique();
            this.index = column.index();
        } else {
            this.columnName = defaultColumnName;
            this.dataType = defaultDataType;
            this.defaultValue = null;
            this.onUpdate = null;
            this.notNull = false;
            this.autoIncrement = false;
            this.primary = false;
            this.unique = false;
            this.index = false;
        }
    }

    @Override
    public FieldInfo javaField() {
        return this.javaField;
    }

    public String name() {
        return this.columnName;
    }

    public AnnotationConfigDataType dataType() {
        return this.dataType;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public String onUpdate() {
        return this.onUpdate;
    }

    public boolean notNull() {
        return this.notNull;
    }

    public boolean autoIncrement() {
        return this.autoIncrement;
    }

    public boolean primary() {
        return this.primary;
    }

    public boolean unique() {
        return this.unique;
    }

    public boolean index() {
        return this.index;
    }
}

