/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.parser;

import cool.scx.data.aggregation.FieldGroupBy;
import cool.scx.data.query.Condition;
import cool.scx.data.query.OrderBy;
import cool.scx.jdbc.dialect.Dialect;
import cool.scx.jdbc.mapping.Column;
import cool.scx.jdbc.mapping.Table;

public final class JDBCColumnNameParser {
    private final Table tableInfo;
    private final Dialect dialect;

    public JDBCColumnNameParser(Table tableInfo, Dialect dialect) {
        this.tableInfo = tableInfo;
        this.dialect = dialect;
    }

    public String parseColumnName(Condition w) {
        return this.parseColumnName(w.selector(), w.useExpression());
    }

    public String parseColumnName(FieldGroupBy g) {
        return this.parseColumnName(g.fieldName(), false);
    }

    public String parseColumnName(OrderBy o) {
        return this.parseColumnName(o.selector(), o.useExpression());
    }

    public String parseColumnName(String name, boolean useExpression) {
        if (useExpression) {
            return "(" + name + ")";
        }
        Column column = this.tableInfo.getColumn(name);
        if (column == null) {
            throw new IllegalArgumentException("\u5728 Table : " + this.tableInfo.name() + " \u4e2d , \u672a\u627e\u5230\u5bf9\u5e94 name \u4e3a : " + name + " \u7684\u5217 !!!");
        }
        return this.dialect.quoteIdentifier(column.name());
    }
}

