/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.parser;

import cool.scx.common.util.ArrayUtils;
import cool.scx.common.util.StringUtils;
import cool.scx.data.jdbc.exception.WrongConditionParamTypeException;
import cool.scx.data.jdbc.exception.WrongConditionTypeParamSizeException;
import cool.scx.data.jdbc.parser.JDBCColumnNameParser;
import cool.scx.data.query.And;
import cool.scx.data.query.Condition;
import cool.scx.data.query.ConditionType;
import cool.scx.data.query.Junction;
import cool.scx.data.query.Not;
import cool.scx.data.query.Or;
import cool.scx.data.query.QueryBuilder;
import cool.scx.data.query.Where;
import cool.scx.data.query.WhereClause;
import cool.scx.jdbc.dialect.Dialect;
import cool.scx.jdbc.sql.SQL;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;

public class JDBCWhereParser {
    private final JDBCColumnNameParser columnNameParser;
    private final Dialect dialect;

    public JDBCWhereParser(JDBCColumnNameParser columnNameParser, Dialect dialect) {
        this.columnNameParser = columnNameParser;
        this.dialect = dialect;
    }

    public static String getWhereKeyWord(Condition condition) {
        return switch (condition.conditionType()) {
            default -> throw new MatchException(null, null);
            case ConditionType.EQ -> "=";
            case ConditionType.NE -> "<>";
            case ConditionType.LT -> "<";
            case ConditionType.LTE -> "<=";
            case ConditionType.GT -> ">";
            case ConditionType.GTE -> ">=";
            case ConditionType.LIKE, ConditionType.LIKE_REGEX -> "LIKE";
            case ConditionType.NOT_LIKE, ConditionType.NOT_LIKE_REGEX -> "NOT LIKE";
            case ConditionType.IN -> "IN";
            case ConditionType.NOT_IN -> "NOT IN";
            case ConditionType.BETWEEN -> "BETWEEN";
            case ConditionType.NOT_BETWEEN -> "NOT BETWEEN";
        };
    }

    public WhereClause parse(Where obj) {
        Where where = obj;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{WhereClause.class, Junction.class, Not.class, Condition.class, SQL.class}, (Where)where, n)) {
            case 0 -> {
                WhereClause w = (WhereClause)where;
                yield this.parseWhereClause(w);
            }
            case 1 -> {
                Junction j = (Junction)where;
                yield this.parseJunction(j);
            }
            case 2 -> {
                Not n = (Not)where;
                yield this.parseNot(n);
            }
            case 3 -> {
                Condition w = (Condition)where;
                yield this.parseCondition(w);
            }
            case 4 -> {
                SQL sql = (SQL)where;
                yield this.parseSQL(sql);
            }
            case -1 -> new WhereClause(null, new Object[0]);
            default -> throw new IllegalArgumentException("Unsupported object type: " + String.valueOf(obj.getClass()));
        };
    }

    private WhereClause parseWhereClause(WhereClause w) {
        return new WhereClause("(" + w.expression() + ")", w.params());
    }

    private WhereClause parseJunction(Junction j) {
        ArrayList<String> clauses = new ArrayList<String>();
        ArrayList whereParams = new ArrayList();
        for (Where c : j.clauses()) {
            WhereClause w = this.parse(c);
            if (w == null || w.isEmpty()) continue;
            clauses.add(w.expression());
            Collections.addAll(whereParams, w.params());
        }
        if (clauses.isEmpty()) {
            return new WhereClause(null, new Object[0]);
        }
        Junction junction = j;
        Objects.requireNonNull(junction);
        Junction junction2 = junction;
        int n = 0;
        String keyWord = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Or.class, And.class}, (Junction)junction2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> "OR";
            case 1 -> "AND";
        };
        Object clause = String.join((CharSequence)(" " + keyWord + " "), clauses);
        if (clauses.size() > 1) {
            clause = "(" + (String)clause + ")";
        }
        return new WhereClause((String)clause, whereParams.toArray());
    }

    private WhereClause parseNot(Not n) {
        WhereClause w = this.parse(n.clause());
        if (w != null && !w.isEmpty()) {
            return new WhereClause("NOT " + w.expression(), w.params());
        }
        return new WhereClause(null, new Object[0]);
    }

    private WhereClause parseSQL(SQL sql) {
        return new WhereClause("(" + sql.sql() + ")", sql.params());
    }

    private WhereClause parseCondition(Condition body) {
        if (body.isEmpty()) {
            return new WhereClause(null, new Object[0]);
        }
        return switch (body.conditionType()) {
            default -> throw new MatchException(null, null);
            case ConditionType.EQ, ConditionType.NE -> this.parseEQ(body);
            case ConditionType.LT, ConditionType.LTE, ConditionType.GT, ConditionType.GTE, ConditionType.LIKE_REGEX, ConditionType.NOT_LIKE_REGEX -> this.parseLT(body);
            case ConditionType.LIKE, ConditionType.NOT_LIKE -> this.parseLIKE(body);
            case ConditionType.IN, ConditionType.NOT_IN -> this.parseIN(body);
            case ConditionType.BETWEEN, ConditionType.NOT_BETWEEN -> this.parseBETWEEN(body);
        };
    }

    private WhereClause parseEQ(Condition w) {
        if (w.value1() == null) {
            String columnName = this.columnNameParser.parseColumnName(w);
            return switch (w.conditionType()) {
                case ConditionType.EQ -> new WhereClause(columnName + " IS NULL", new Object[0]);
                case ConditionType.NE -> new WhereClause(columnName + " IS NOT NULL", new Object[0]);
                default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf(w.conditionType()));
            };
        }
        String columnDefinition = this.columnNameParser.parseColumnName(w) + " " + JDBCWhereParser.getWhereKeyWord(w) + " ";
        if (w.useExpressionValue()) {
            return new WhereClause(columnDefinition + "(" + String.valueOf(w.value1()) + ")", new Object[0]);
        }
        Object object = w.value1();
        if (object instanceof SQL) {
            SQL a = (SQL)object;
            return new WhereClause(columnDefinition + "(" + a.sql() + ")", a.params());
        }
        return new WhereClause(columnDefinition + "?", new Object[]{w.value1()});
    }

    private WhereClause parseLT(Condition w) {
        if (w.value1() == null) {
            throw new WrongConditionTypeParamSizeException(w.selector(), w.conditionType(), 1);
        }
        String columnDefinition = this.columnNameParser.parseColumnName(w) + " " + JDBCWhereParser.getWhereKeyWord(w) + " ";
        if (w.useExpressionValue()) {
            return new WhereClause(columnDefinition + "(" + String.valueOf(w.value1()) + ")", new Object[0]);
        }
        Object object = w.value1();
        if (object instanceof SQL) {
            SQL a = (SQL)object;
            return new WhereClause(columnDefinition + "(" + a.sql() + ")", a.params());
        }
        return new WhereClause(columnDefinition + "?", new Object[]{w.value1()});
    }

    private WhereClause parseLIKE(Condition w) {
        if (w.value1() == null) {
            throw new WrongConditionTypeParamSizeException(w.selector(), w.conditionType(), 1);
        }
        String columnDefinition = this.columnNameParser.parseColumnName(w) + " " + JDBCWhereParser.getWhereKeyWord(w) + " ";
        if (w.useExpressionValue()) {
            return new WhereClause(columnDefinition + "CONCAT('%',(" + String.valueOf(w.value1()) + "),'%')", new Object[0]);
        }
        Object object = w.value1();
        if (object instanceof SQL) {
            SQL a = (SQL)object;
            return new WhereClause(columnDefinition + "CONCAT('%',(" + a.sql() + "),'%')", a.params());
        }
        return new WhereClause(columnDefinition + "CONCAT('%',?,'%')", new Object[]{w.value1()});
    }

    private WhereClause parseIN(Condition w) {
        Object[] v;
        if (w.value1() == null) {
            throw new WrongConditionTypeParamSizeException(w.selector(), w.conditionType(), 1);
        }
        String columnName = this.columnNameParser.parseColumnName(w);
        if (w.useExpressionValue()) {
            return new WhereClause(columnName + " " + JDBCWhereParser.getWhereKeyWord(w) + " (" + String.valueOf(w.value1()) + ")", new Object[0]);
        }
        Object object = w.value1();
        if (object instanceof SQL) {
            SQL a = (SQL)object;
            return new WhereClause(columnName + " " + JDBCWhereParser.getWhereKeyWord(w) + " (" + a.sql() + ")", a.params());
        }
        try {
            v = ArrayUtils.toObjectArray((Object)w.value1());
        }
        catch (Exception e) {
            throw new WrongConditionParamTypeException(w.selector(), w.conditionType(), "\u6570\u7ec4");
        }
        if (v.length == 0) {
            return switch (w.conditionType()) {
                case ConditionType.IN -> new WhereClause(this.dialect.falseExpression(), new Object[0]);
                case ConditionType.NOT_IN -> new WhereClause(this.dialect.trueExpression(), new Object[0]);
                default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf(w.conditionType()));
            };
        }
        Object[] nonNullValues = Arrays.stream(v).filter(Objects::nonNull).distinct().toArray();
        boolean containsNull = Arrays.stream(v).anyMatch(Objects::isNull);
        if (containsNull) {
            WhereClause nullClause = switch (w.conditionType()) {
                case ConditionType.IN -> new WhereClause(columnName + " IS NULL", new Object[0]);
                case ConditionType.NOT_IN -> new WhereClause(columnName + " IS NOT NULL", new Object[0]);
                default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf(w.conditionType()));
            };
            if (nonNullValues.length == 0) {
                return nullClause;
            }
            String placeholder = StringUtils.repeat((String)"?", (String)", ", (int)nonNullValues.length);
            WhereClause inClause = new WhereClause(columnName + " " + JDBCWhereParser.getWhereKeyWord(w) + " (" + placeholder + ")", nonNullValues);
            Junction j = switch (w.conditionType()) {
                case ConditionType.IN -> QueryBuilder.or((Where[])new Where[]{inClause, nullClause});
                case ConditionType.NOT_IN -> QueryBuilder.and((Where[])new Where[]{inClause, nullClause});
                default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf(w.conditionType()));
            };
            return this.parseJunction(j);
        }
        String placeholder = StringUtils.repeat((String)"?", (String)", ", (int)nonNullValues.length);
        return new WhereClause(columnName + " " + JDBCWhereParser.getWhereKeyWord(w) + " (" + placeholder + ")", nonNullValues);
    }

    private WhereClause parseBETWEEN(Condition w) {
        Object v2;
        Object v1;
        if (w.value1() == null || w.value2() == null) {
            throw new WrongConditionTypeParamSizeException(w.selector(), w.conditionType(), 2);
        }
        String columnName = this.columnNameParser.parseColumnName(w);
        String columnDefinition = columnName + " " + JDBCWhereParser.getWhereKeyWord(w) + " ";
        ArrayList<Object> whereParams = new ArrayList<Object>();
        if (w.useExpressionValue()) {
            String v12 = "(" + String.valueOf(w.value1()) + ")";
            String v22 = "(" + String.valueOf(w.value2()) + ")";
            return new WhereClause(columnDefinition + v12 + " AND " + v22, new Object[0]);
        }
        Object object = w.value1();
        if (object instanceof SQL) {
            SQL a1 = (SQL)object;
            v1 = "(" + a1.sql() + ")";
            Collections.addAll(whereParams, a1.params());
        } else {
            v1 = "?";
            whereParams.add(w.value1());
        }
        object = w.value2();
        if (object instanceof SQL) {
            SQL a2 = (SQL)object;
            v2 = "(" + a2.sql() + ")";
            Collections.addAll(whereParams, a2.params());
        } else {
            v2 = "?";
            whereParams.add(w.value2());
        }
        return new WhereClause(columnDefinition + (String)v1 + " AND " + (String)v2, whereParams.toArray());
    }
}

