/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.sql_builder;

import cool.scx.common.util.ArrayUtils;
import cool.scx.common.util.StringUtils;
import cool.scx.data.aggregation.Agg;
import cool.scx.data.aggregation.Aggregation;
import cool.scx.data.aggregation.ExpressionGroupBy;
import cool.scx.data.aggregation.FieldGroupBy;
import cool.scx.data.aggregation.GroupBy;
import cool.scx.data.jdbc.mapping.EntityTable;
import cool.scx.data.jdbc.parser.JDBCGroupByParser;
import cool.scx.data.jdbc.parser.JDBCOrderByParser;
import cool.scx.data.jdbc.parser.JDBCWhereParser;
import cool.scx.data.query.Query;
import cool.scx.data.query.WhereClause;
import cool.scx.jdbc.dialect.Dialect;
import cool.scx.jdbc.sql.SQL;
import java.util.ArrayList;

public class AggregateSQLBuilder {
    private final EntityTable<?> table;
    private final Dialect dialect;
    private final JDBCWhereParser whereParser;
    private final JDBCGroupByParser groupByParser;
    private final JDBCOrderByParser orderByParser;

    public AggregateSQLBuilder(EntityTable<?> table, Dialect dialect, JDBCWhereParser whereParser, JDBCGroupByParser groupByParser, JDBCOrderByParser orderByParser) {
        this.table = table;
        this.dialect = dialect;
        this.whereParser = whereParser;
        this.groupByParser = groupByParser;
        this.orderByParser = orderByParser;
    }

    public SQL buildAggregateSQL(Query beforeAggregateQuery, Aggregation aggregation, Query afterAggregateQuery) {
        String[] selectColumns = this.createSelectColumn(aggregation);
        WhereClause whereClause = this.whereParser.parse(beforeAggregateQuery.getWhere());
        String[] groupByColumn = this.createGroupByColumn(aggregation);
        WhereClause havingClause = this.whereParser.parse(afterAggregateQuery.getWhere());
        String[] orderByClauses = this.orderByParser.parse(afterAggregateQuery.getOrderBys());
        String sql = this.GetAggregateSQL(selectColumns, whereClause.expression(), groupByColumn, havingClause.expression(), orderByClauses, afterAggregateQuery.getOffset(), afterAggregateQuery.getLimit());
        Object[] finalParams = ArrayUtils.concat((Object[][])new Object[][]{whereClause.params(), havingClause.params()});
        return SQL.sql((String)sql, (Object[])finalParams);
    }

    public SQL buildAggregateFirstSQL(Query beforeAggregateQuery, Aggregation aggregation, Query afterAggregateQuery) {
        String[] selectColumns = this.createSelectColumn(aggregation);
        WhereClause whereClause = this.whereParser.parse(beforeAggregateQuery.getWhere());
        String[] groupByColumn = this.createGroupByColumn(aggregation);
        WhereClause havingClause = this.whereParser.parse(afterAggregateQuery.getWhere());
        String[] orderByClauses = this.orderByParser.parse(afterAggregateQuery.getOrderBys());
        String sql = this.GetAggregateSQL(selectColumns, whereClause.expression(), groupByColumn, havingClause.expression(), orderByClauses, null, 1L);
        Object[] finalParams = ArrayUtils.concat((Object[][])new Object[][]{whereClause.params(), havingClause.params()});
        return SQL.sql((String)sql, (Object[])finalParams);
    }

    private String GetAggregateSQL(String[] selectColumns, String whereClause, String[] groupByColumns, String havingClause, String[] orderByClauses, Long offset, Long limit) {
        if (selectColumns.length == 0) {
            throw new IllegalArgumentException("Select \u5b50\u53e5\u9519\u8bef : \u5f85\u67e5\u8be2\u7684\u6570\u636e\u5217 \u4e0d\u80fd\u4e3a\u7a7a !!!");
        }
        String sql = "SELECT " + String.join((CharSequence)", ", selectColumns) + " FROM " + this.getTableName() + this.getWhereClause(whereClause) + this.getGroupByColumns(groupByColumns) + this.getHavingClause(havingClause) + this.getOrderByClause(orderByClauses);
        return this.dialect.applyLimit(sql, offset, limit);
    }

    private String getOrderByClause(String[] orderByClauses) {
        return orderByClauses != null && orderByClauses.length != 0 ? " ORDER BY " + String.join((CharSequence)", ", orderByClauses) : "";
    }

    private String getHavingClause(String havingClause) {
        return StringUtils.notEmpty((String)havingClause) ? " HAVING " + havingClause : "";
    }

    private String getGroupByColumns(String[] groupByColumns) {
        return groupByColumns != null && groupByColumns.length != 0 ? " GROUP BY " + String.join((CharSequence)", ", groupByColumns) : "";
    }

    private String getWhereClause(String whereClause) {
        return StringUtils.notEmpty((String)whereClause) ? " WHERE " + whereClause : "";
    }

    private String getTableName() {
        return this.dialect.quoteIdentifier(this.table.name());
    }

    public String[] createSelectColumn(Aggregation aggregation) {
        Agg[] aggs = aggregation.getAggs();
        GroupBy[] groupBys = aggregation.getGroupBys();
        ArrayList<Object> selectColumn = new ArrayList<Object>();
        for (Agg agg : aggs) {
            selectColumn.add(agg.expression() + " AS " + this.dialect.quoteIdentifier(agg.alias()));
        }
        for (Agg agg : groupBys) {
            FieldGroupBy f;
            if (agg instanceof FieldGroupBy) {
                f = (FieldGroupBy)agg;
                String s = this.groupByParser.parseGroupBy(f);
                selectColumn.add(s);
            }
            if (!(agg instanceof ExpressionGroupBy)) continue;
            f = (ExpressionGroupBy)agg;
            selectColumn.add(f.expression() + " AS " + this.dialect.quoteIdentifier(f.alias()));
        }
        return (String[])selectColumn.toArray(String[]::new);
    }

    public String[] createGroupByColumn(Aggregation aggregation) {
        GroupBy[] groupBys = aggregation.getGroupBys();
        ArrayList<String> groupByColumn = new ArrayList<String>();
        for (GroupBy groupBy : groupBys) {
            FieldGroupBy f;
            if (groupBy instanceof FieldGroupBy) {
                f = (FieldGroupBy)groupBy;
                String s = this.groupByParser.parseGroupBy(f);
                groupByColumn.add(s);
            }
            if (!(groupBy instanceof ExpressionGroupBy)) continue;
            f = (ExpressionGroupBy)groupBy;
            groupByColumn.add(this.dialect.quoteIdentifier(f.alias()));
        }
        return (String[])groupByColumn.toArray(String[]::new);
    }
}

