/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.sql_builder;

import cool.scx.common.util.StringUtils;
import cool.scx.data.jdbc.parser.JDBCWhereParser;
import cool.scx.data.query.Query;
import cool.scx.data.query.WhereClause;
import cool.scx.jdbc.dialect.Dialect;
import cool.scx.jdbc.mapping.Table;
import cool.scx.jdbc.sql.SQL;

public class CountSQLBuilder {
    private final JDBCWhereParser whereParser;
    private final Table table;
    private final Dialect dialect;

    public CountSQLBuilder(Table table, Dialect dialect, JDBCWhereParser whereParser) {
        this.whereParser = whereParser;
        this.table = table;
        this.dialect = dialect;
    }

    public SQL buildCountSQL(Query query) {
        WhereClause whereClause = this.whereParser.parse(query.getWhere());
        String sql = this.GetCountSQL(whereClause.expression());
        return SQL.sql((String)sql, (Object[])whereClause.params());
    }

    private String GetCountSQL(String whereClause) {
        return "SELECT COUNT(*) AS count FROM " + this.getTableName(this.dialect) + this.getWhereClause(whereClause);
    }

    private String getTableName(Dialect dialect) {
        return dialect.quoteIdentifier(this.table.name());
    }

    private String getWhereClause(String whereClause) {
        return StringUtils.notEmpty((String)whereClause) ? " WHERE " + whereClause : "";
    }
}

